/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.nidas.model;

import edu.ucar.nidas.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serializer.DOMSerializer;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDom {
    public static String lineFeed = "\n";
    protected Document _doc;

    public Document getDoc() {
        return this._doc;
    }

    public Document parseXmlFile(String string, boolean bl) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(bl);
            this._doc = documentBuilderFactory.newDocumentBuilder().parse(new File(string));
            return this._doc;
        }
        catch (SAXException sAXException) {
            Util.prtException(sAXException, "A parsing error occurred; the xml input is not valid.\n" + sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Util.prtException(parserConfigurationException, "A parsing config error occurred; the xml parsing failed.\n" + parserConfigurationException.getMessage());
        }
        catch (IOException iOException) {
            Util.prtException(iOException, "An i/o exception error occurred; the xml parsing failed.\n" + iOException.getMessage());
        }
        return null;
    }

    public Document parseXmlFile(InputStream inputStream, boolean bl) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(bl);
            this._doc = documentBuilderFactory.newDocumentBuilder().parse(inputStream);
            return this._doc;
        }
        catch (SAXException sAXException) {
            Util.prtException(sAXException, "A parsing error occurred; the inputStream is not valid.\n" + inputStream.toString() + "\n" + sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Util.prtException(parserConfigurationException, "A parsing config error occurred; the inputStream is not valid.\n" + inputStream.toString() + parserConfigurationException.getMessage());
        }
        catch (IOException iOException) {
            Util.prtException(iOException, "An i/o exception error occurred; the inputStream is not valid.\n" + inputStream.toString() + iOException.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveXmldoc(Document document, String string) {
        Properties properties = OutputPropertiesFactory.getDefaultMethodProperties("xml");
        Serializer serializer = SerializerFactory.getSerializer(properties);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
            serializer.setOutputStream(fileOutputStream);
            DOMSerializer dOMSerializer = serializer.asDOMSerializer();
            dOMSerializer.serialize(document);
            fileOutputStream.close();
            serializer.reset();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Util.prtException(fileNotFoundException, "Cannot create file writer to " + string + ", config is not saved.\n" + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            Util.prtException(iOException, "Encount IO exception, config is not saved.\n" + iOException.getMessage());
        }
        finally {
            serializer.reset();
        }
    }

    public Node getNode(NodeList nodeList, String string) {
        if (nodeList == null) {
            return null;
        }
        if (nodeList.getLength() == 1) {
            return nodeList.item(0);
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2 = nodeList.item(i).getNodeName();
            if (!string2.equals(string)) continue;
            return nodeList.item(i);
        }
        return null;
    }

    public Node getNode(NodeList nodeList, String string, String string2) {
        if (nodeList == null) {
            return null;
        }
        if (nodeList.getLength() == 1) {
            return nodeList.item(0);
        }
        if (string == null) {
            return nodeList.item(nodeList.getLength() - 1);
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i).getAttributes().getNamedItem(string);
            if (node == null || !node.getNodeValue().equals(string2)) continue;
            return nodeList.item(i);
        }
        return null;
    }

    public Node getNode(String string, String string2, String string3) {
        if (this._doc == null) {
            Util.prtErr("Doc is mepty. Cannot retrieve a node...");
            return null;
        }
        NodeList nodeList = this._doc.getElementsByTagName(string);
        return this.getNode(nodeList, string2, string3);
    }

    public String getValue(String string, String string2, String string3, String string4) {
        Node node = this.getNode(string, string2, string3);
        if (node == null) {
            return null;
        }
        Node node2 = node.getAttributes().getNamedItem(string4);
        if (node2 == null) {
            return null;
        }
        return node2.getNodeValue();
    }

    public String getValue(Node node, String string) {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            return null;
        }
        return node2.getNodeValue();
    }

    public void setAttribute(String string, String string2, String string3, String string4, String string5) {
        Node node = this.getNode(string, string2, string3);
        if (node == null) {
            Util.prtErr("Reset attribute failed.\n attr= " + string4 + " attrVal= " + string5);
            return;
        }
        Node node2 = node.getAttributes().getNamedItem(string4);
        if (node2 == null) {
            return;
        }
        node2.setNodeValue(string5);
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5) {
        if (this._doc == null) {
            Util.prtErr("Doc is mepty...");
            return;
        }
        Node node = this.getNode(string, string2, string3);
        if (node == null) {
            Util.prtErr("Cannot find the node.addAttribute failed. " + string2 + "  " + string3);
            return;
        }
        Attr attr = this._doc.createAttribute(string4);
        attr.setValue(string5);
        node.getAttributes().setNamedItem(attr);
    }

    public void removeAttribute(String string, String string2, String string3, String string4) {
        Node node = this.getNode(string, string2, string3);
        if (node == null) {
            Util.prtErr("Remove attribute failed.\n attr= " + string2 + " attrVal= " + string3);
            return;
        }
        try {
            node.getAttributes().removeNamedItem(string4);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addNode(String string, String string2, String string3, String string4, String string5, String string6) throws DOMException {
        Attr attr;
        Element element;
        Object object;
        Object object2;
        if (this._doc == null) {
            try {
                object2 = DocumentBuilderFactory.newInstance();
                object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
                this._doc = ((DocumentBuilder)object).newDocument();
                element = this._doc.createElement(string);
                if (string2 != null) {
                    attr = this._doc.createAttribute(string2);
                    if (string3 != null) {
                        attr.setValue(string3);
                    }
                    element.getAttributes().setNamedItem(attr);
                }
                element.setTextContent(lineFeed);
                this._doc.appendChild(element);
            }
            catch (Exception exception) {
                Util.prtDbg("_doc is empty; addNode failed...");
            }
        }
        if ((object2 = this.getNode(string4, "name", string5)) != null) {
            Util.prtErr(" There is a duplicated node exists.\n Node_tag=" + string4 + "\n name_id= " + string5 + "\n Get a new name_id?");
        }
        object = this.getNode(string, string2, string3);
        element = this._doc.createElement(string4);
        element.setTextContent(lineFeed);
        attr = this._doc.createAttribute("name");
        if (string5 != null) {
            attr.setValue(string5);
        }
        element.getAttributes().setNamedItem(attr);
        if (object == null) {
            this._doc.appendChild(element);
        } else {
            object.appendChild(element);
        }
    }

    public void addNode(String string, String string2, String string3, String string4, ArrayList<String> arrayList) throws DOMException {
        Object object;
        if (this._doc == null) {
            Util.prtDbg("_doc is empty; addNode failed...");
            return;
        }
        Element element = this._doc.createElement(string4);
        for (int i = 0; i < arrayList.size(); ++i) {
            object = arrayList.get(i);
            Attr attr = this._doc.createAttribute(((String)object).split(" ")[0]);
            assert (((String)object).split(" ").length == 2);
            attr.setValue(((String)object).split(" ")[1]);
            element.getAttributes().setNamedItem(attr);
        }
        element.setTextContent(lineFeed);
        NodeList nodeList = this._doc.getElementsByTagName(string);
        if (nodeList == null || nodeList.getLength() <= 0) {
            Util.prtDbg("No node named " + string + " exists. ");
            return;
        }
        object = string2 == null || string3 == null ? nodeList.item(nodeList.getLength() - 1) : this.getNode(nodeList, string2, string3);
        if (object == null) {
            this._doc.appendChild(element);
        } else {
            object.appendChild(element);
        }
    }

    public void removeNode(String string, String string2, String string3, String string4) {
        Node node = this.getNode(string, string2, string3);
        if (node == null) {
            Util.prtErr("Cannot find the node.removeNode failed. " + string2 + "  " + string3);
            return;
        }
        Node node2 = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string4)) continue;
            node.removeChild(node2);
            return;
        }
    }
}

