/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.nidas.core;

import edu.ucar.nidas.core.UdpFeedInf;
import edu.ucar.nidas.util.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.net.UnknownServiceException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UdpFeedFinder {
    String _servName;
    int _port;
    DatagramSocket _dsocket;
    InetAddress _servAddr;
    InetSocketAddress _servSAddr;
    DatagramPacket _packet;
    byte[] _buffer;
    ByteBuffer _bf;
    int _rcvSckLocalPort;
    public static int MAX_TIMEOUT = 2000;
    List<UdpFeedInf> _servs = new ArrayList<UdpFeedInf>();

    public int getRcvSckLocalPort() {
        return this._rcvSckLocalPort;
    }

    public DatagramSocket getRcvDataSock() {
        return this._dsocket;
    }

    public InetAddress getServAddr() {
        return this._servAddr;
    }

    public InetSocketAddress getServSocketAddress() {
        return this._servSAddr;
    }

    public List<UdpFeedInf> findServers(String string, int n) throws IOException {
        this._servName = string;
        this._port = n;
        Util.prtDbg("UdpServInfReader- findServers- sernname =" + this._servName + " port=" + this._port);
        this._servAddr = InetAddress.getByName(this._servName);
        if (this._servAddr.isMulticastAddress()) {
            MulticastSocket multicastSocket = new MulticastSocket(0);
            this._dsocket = multicastSocket;
        } else {
            this._dsocket = new DatagramSocket();
        }
        this._rcvSckLocalPort = this._dsocket.getLocalPort();
        Util.prtDbg("dsocket_port=" + this._rcvSckLocalPort);
        this.buildClientInfPack((short)this._rcvSckLocalPort);
        this._servSAddr = new InetSocketAddress(this._servAddr, this._port);
        this._packet.setSocketAddress(this._servSAddr);
        this._servs.clear();
        long l = System.currentTimeMillis();
        this._dsocket.setSoTimeout(2500);
        for (int i = 0; i < 3 && this._servs.size() == 0; ++i) {
            this._dsocket.send(this._packet);
            Util.prtDbg("sent # bytes=" + this._packet.getLength());
            while (l + 2000L > System.currentTimeMillis()) {
                int n2 = 1024;
                byte[] byArray = new byte[n2];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, n2);
                try {
                    this._dsocket.receive(datagramPacket);
                    Util.prtDbg("received # bytes=" + datagramPacket.getLength());
                    UdpFeedInf udpFeedInf = this.parseDataFeederInf(datagramPacket);
                    this._servs.add(udpFeedInf);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (Exception exception) {
                    Util.prtException(exception, "UdpServInfReader- dsocket-receiving-error...");
                }
            }
        }
        this._dsocket.setSoTimeout(0);
        return this._servs;
    }

    public void closeSocket() {
        try {
            this._dsocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getString(ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        int n;
        int n2 = byteBuffer.position();
        if (n2 == (n = byteBuffer.limit())) {
            return null;
        }
        byte[] byArray = new byte[n - n2];
        int n3 = 0;
        while (n2 < n && (byArray[n3++] = byteBuffer.get()) != 0) {
            ++n2;
        }
        return new String(byArray, 0, n3, "UTF-8");
    }

    public UdpFeedInf parseDataFeederInf(DatagramPacket datagramPacket) throws IOException {
        String string;
        if (datagramPacket == null || datagramPacket.getLength() <= 0) {
            Util.prtErr("ServInfThread->run(): pacakge is null");
            return null;
        }
        byte[] byArray = datagramPacket.getData();
        Util.prtDbg("Received server inf data from: " + datagramPacket.getAddress().toString() + ":" + datagramPacket.getPort() + " with length: " + datagramPacket.getLength());
        Util.prtDbg(byArray.toString());
        UdpFeedInf udpFeedInf = new UdpFeedInf();
        udpFeedInf.setIpAddr(datagramPacket.getAddress());
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, datagramPacket.getLength());
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        int n = byteBuffer.getInt();
        if (n != 1985229328) {
            throw new UnknownServiceException("incorrect magic number received: " + Integer.toHexString(n));
        }
        udpFeedInf.setPort(byteBuffer.getShort());
        Util.prtDbg("tcp-port=" + udpFeedInf.getPort());
        udpFeedInf.setUDPPort(byteBuffer.getShort());
        Util.prtDbg("udp-port=" + udpFeedInf.getUDPPort());
        udpFeedInf.setServ(datagramPacket.getAddress().getHostName());
        this.getString(byteBuffer);
        udpFeedInf.setProjectName(this.getString(byteBuffer));
        while ((string = this.getString(byteBuffer)) != null) {
            udpFeedInf.addDsm(string);
            Util.prtDbg("dsm=" + string);
        }
        udpFeedInf.printServInf();
        return udpFeedInf;
    }

    private void buildClientInfPack(short s) {
        byte[] byArray = new byte[4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.putInt(19088743);
        byte[] byArray2 = new byte[4];
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray2);
        byteBuffer2.order(ByteOrder.BIG_ENDIAN);
        byteBuffer2.putInt(2);
        byte[] byArray3 = new byte[2];
        ByteBuffer byteBuffer3 = ByteBuffer.wrap(byArray3);
        byteBuffer3.order(ByteOrder.BIG_ENDIAN);
        byteBuffer3.putShort(s);
        byte[] byArray4 = new byte[2];
        ByteBuffer byteBuffer4 = ByteBuffer.wrap(byArray4);
        byteBuffer4.order(ByteOrder.BIG_ENDIAN);
        byteBuffer4.putShort((short)2);
        int n = 12;
        this._buffer = new byte[n];
        this._bf = ByteBuffer.wrap(this._buffer);
        this._bf.put(byteBuffer.array());
        this._bf.put(byteBuffer2.array());
        this._bf.put(byteBuffer3.array());
        this._bf.put(byteBuffer4.array());
        this._packet = new DatagramPacket(this._bf.array(), n);
    }
}

