/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.nidas.core;

import edu.ucar.nidas.apps.cockpit.core.DataDescriptorReader;
import edu.ucar.nidas.core.UdpFeedFinder;
import edu.ucar.nidas.core.UdpFeedInf;
import edu.ucar.nidas.util.Util;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import org.w3c.dom.Document;

public class UdpFeed {
    DatagramSocket _dsocket;
    Socket _tcpsocket;
    Document _doc;
    UdpFeedFinder _udp;
    UdpFeedInf _inf;

    public UdpFeed(UdpFeedFinder udpFeedFinder, UdpFeedInf udpFeedInf) {
        this.setDatagramSocket(udpFeedFinder, udpFeedInf);
        this._udp = udpFeedFinder;
        this._inf = udpFeedInf;
        this._doc = this.readXml(this._inf.getIpAddr(), this._inf.getPort(), this._udp.getRcvSckLocalPort());
    }

    public DatagramSocket getUdpSocket() {
        return this._dsocket;
    }

    public Socket geTcptSocket() {
        return this._tcpsocket;
    }

    public Document getXmlDoc() {
        return this._doc;
    }

    private Document readXml(InetAddress inetAddress, int n, int n2) {
        if (inetAddress == null) {
            Util.prtErr("Tcp Server is null...");
            return null;
        }
        Util.prtDbg("readXml- serv=" + inetAddress.toString() + " = " + inetAddress.getHostName() + "  port=" + n);
        try {
            DataDescriptorReader dataDescriptorReader = new DataDescriptorReader();
            Document document = dataDescriptorReader.readXml(inetAddress, n, n2);
            this._tcpsocket = dataDescriptorReader.getTcpSocket();
            this._tcpsocket.setKeepAlive(true);
            return document;
        }
        catch (Exception exception) {
            Util.prtException(exception, "cockpit-readXml exception");
            return null;
        }
    }

    private void setDatagramSocket(UdpFeedFinder udpFeedFinder, UdpFeedInf udpFeedInf) {
        Util.prtDbg(" udpfeed-joinMulticastGroup--");
        if (udpFeedFinder == null) {
            Util.prtErr(" No data server found... \n Please check data server and retry");
            return;
        }
        if (udpFeedInf == null) {
            Util.prtErr(" No data server found... \n Please check data server and retry");
            return;
        }
        Util.prtDbg("connect or join-multicastGroup datagram socket ======");
        InetAddress inetAddress = udpFeedFinder.getServAddr();
        this._dsocket = udpFeedFinder.getRcvDataSock();
        try {
            if (!inetAddress.isMulticastAddress()) {
                return;
            }
            this._dsocket.close();
            MulticastSocket multicastSocket = new MulticastSocket(udpFeedInf.getUDPPort());
            this._dsocket = multicastSocket;
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, udpFeedInf.getUDPPort());
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Util.prtDbg("mcSaddr=" + inetSocketAddress.toString() + " joining interface=" + networkInterface.toString());
                boolean bl = false;
                try {
                    Method method = networkInterface.getClass().getMethod("isUp", new Class[0]);
                    Boolean bl2 = (boolean)((Boolean)method.invoke((Object)networkInterface, new Object[0]));
                    Util.prtDbg("isUp b1=" + bl2);
                    method = networkInterface.getClass().getMethod("supportsMulticast", new Class[0]);
                    Boolean bl3 = (boolean)((Boolean)method.invoke((Object)networkInterface, new Object[0]));
                    Util.prtDbg("supportsMulticast b2=" + bl3);
                    method = networkInterface.getClass().getMethod("isLoopback", new Class[0]);
                    Boolean bl4 = (boolean)((Boolean)method.invoke((Object)networkInterface, new Object[0]));
                    Util.prtDbg("isLoopback b3=" + bl4);
                    if (bl2.booleanValue() && (bl3.booleanValue() || bl4.booleanValue())) {
                        Util.prtDbg("isUp and etc methods are found and joinG=true");
                        bl = true;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Util.prtDbg("No such mehtod found and joinG=true");
                    bl = true;
                }
                if (!bl) continue;
                multicastSocket.joinGroup(inetSocketAddress, networkInterface);
            }
            this._dsocket.setSoTimeout(0);
        }
        catch (SocketException socketException) {
            Util.prtException(socketException, "cockpit-rebind datagram Socket exception");
            return;
        }
        catch (IOException iOException) {
            Util.prtException(iOException, "cockpit-rebind datagram IO exception");
            return;
        }
        catch (Exception exception) {
            Util.prtException(exception, "cockpit-rebind datagram exception");
            return;
        }
    }

    public void closeSocket() {
        try {
            this._dsocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this._tcpsocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

