/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.nidas.core;

import edu.ucar.nidas.apps.cockpit.core.ReconnectionClient;
import edu.ucar.nidas.apps.cockpit.model.DataClient;
import edu.ucar.nidas.core.FloatSample;
import edu.ucar.nidas.core.NidasSampleParser;
import edu.ucar.nidas.core.UdpFeed;
import edu.ucar.nidas.model.Sample;
import edu.ucar.nidas.model.Var;
import edu.ucar.nidas.ui.StatusBarClient;
import edu.ucar.nidas.util.Util;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UdpDataReaderThread
extends Thread {
    UdpFeed _udpf;
    ReconnectionClient _rc;
    StatusBarClient _sbc;
    public static int _buffLen = 16384;
    private DatagramPacket _packet;
    private ByteBuffer _bf;
    private DatagramSocket _dsocket;
    NidasSampleParser _nsp = new NidasSampleParser();
    HashMap<Integer, ArrayList<Var>> _idToVars = new HashMap();
    HashMap<Var, ArrayList<ArrayList<DataClient>>> _varToClients = new HashMap();
    boolean _abort = false;

    public synchronized void abort() {
        this._abort = true;
    }

    public void setRC(ReconnectionClient reconnectionClient) {
        this._rc = reconnectionClient;
    }

    public HashMap<Integer, ArrayList<Var>> getIdToVars() {
        return this._idToVars;
    }

    public void setIdToVars(HashMap<Integer, ArrayList<Var>> hashMap) {
        this._idToVars = hashMap;
    }

    public HashMap<Var, ArrayList<ArrayList<DataClient>>> getVarToClients() {
        return this._varToClients;
    }

    public void setVarToClients(HashMap<Var, ArrayList<ArrayList<DataClient>>> hashMap) {
        this._varToClients = hashMap;
    }

    public void setUdpFeed(UdpFeed udpFeed) {
        this._udpf = udpFeed;
    }

    public void setStatusBar(StatusBarClient statusBarClient) {
        this._sbc = statusBarClient;
    }

    private void buildDataBuf() {
        byte[] byArray = new byte[_buffLen];
        this._packet = new DatagramPacket(byArray, byArray.length);
        this._bf = ByteBuffer.wrap(byArray, 0, byArray.length);
        this._bf.order(ByteOrder.LITTLE_ENDIAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClient(Sample sample, Var var, int n, DataClient dataClient) {
        HashMap<Var, ArrayList<ArrayList<DataClient>>> hashMap = this._varToClients;
        synchronized (hashMap) {
            ArrayList<DataClient> arrayList;
            ArrayList<ArrayList<DataClient>> arrayList2;
            ArrayList<Var> arrayList3 = this._idToVars.get(sample.getId());
            if (arrayList3 == null) {
                arrayList3 = sample.getVars();
                this._idToVars.put(sample.getId(), arrayList3);
            }
            if ((arrayList2 = this._varToClients.get(var)) == null || n >= arrayList2.size()) {
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList();
                }
                this._varToClients.put(var, arrayList2);
                for (int i = arrayList2.size(); i < n; ++i) {
                    arrayList2.add(new ArrayList());
                }
                arrayList = new ArrayList();
                arrayList2.add(arrayList);
            } else {
                arrayList = arrayList2.get(n);
            }
            arrayList.remove(dataClient);
            arrayList.add(dataClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Util.prtDbg("dataTh-run()");
        this.buildDataBuf();
        boolean bl = false;
        this._dsocket = this._udpf.getUdpSocket();
        while (!this._abort) {
            FloatSample floatSample;
            try {
                this._dsocket.setSoTimeout(10000);
                this._dsocket.receive(this._packet);
            }
            catch (Exception exception) {
                this.reconnect();
                return;
            }
            this._bf.limit(this._packet.getLength());
            while ((floatSample = this._nsp.parseSample(this._bf, this._packet.getLength())) != null) {
                int n = floatSample.getId();
                HashMap<Var, ArrayList<ArrayList<DataClient>>> hashMap = this._varToClients;
                synchronized (hashMap) {
                    if (this._idToVars == null || this._idToVars.size() <= 0) {
                        continue;
                    }
                    ArrayList<Var> arrayList = this._idToVars.get(floatSample.getId());
                    if (arrayList == null || arrayList.size() <= 0) {
                        continue;
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        Var var = arrayList.get(i);
                        int n2 = var.getOffset();
                        ArrayList<ArrayList<DataClient>> arrayList2 = this._varToClients.get(var);
                        for (int j = 0; j < var.getLength(); ++j) {
                            if (arrayList2 == null || j >= arrayList2.size()) continue;
                            ArrayList<DataClient> arrayList3 = arrayList2.get(j);
                            for (int k = 0; k < arrayList3.size(); ++k) {
                                DataClient dataClient = arrayList3.get(k);
                                if (dataClient == null) continue;
                                dataClient.receive(floatSample, n2 + j);
                            }
                        }
                    }
                }
            }
            this._bf.rewind();
        }
        this._udpf.closeSocket();
        Util.prtDbg("dataTh-run()--endof-data-loop");
    }

    private void reconnect() {
        if (this._rc == null) {
            if (this._sbc != null) {
                this._sbc.receive("_reconneciton-client is null ", 10);
            }
            return;
        }
        if (this._sbc != null) {
            this._sbc.receive("No data from the data feed. Reconnecting...", -1);
        }
        this._rc.setReconnect();
        this._udpf.closeSocket();
    }
}

