/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.nidas.core;

import edu.ucar.nidas.core.FloatSample;
import java.nio.ByteBuffer;

public class NidasSampleParser {
    static final int headLen = 16;
    static final int floatSize = 4;
    static final int doubleSize = 8;
    private float[] _fdata;

    public FloatSample parseFloatSample(ByteBuffer byteBuffer, int n) {
        if (n - byteBuffer.position() < 16) {
            return null;
        }
        long l = byteBuffer.getLong() / 1000L;
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt() & 0x3FFFFFF;
        if (n - byteBuffer.position() < n2) {
            return null;
        }
        int n4 = n2 / 4;
        this._fdata = new float[n4];
        for (int i = 0; i < n4; ++i) {
            this._fdata[i] = byteBuffer.getFloat();
        }
        return new FloatSample(l, n3, this._fdata);
    }

    public FloatSample parseSample(ByteBuffer byteBuffer, int n) {
        if (n - byteBuffer.position() < 16) {
            return null;
        }
        long l = byteBuffer.getLong() / 1000L;
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        int n4 = n3 & 0x3FFFFFF;
        int n5 = n3 >> 26;
        if (n - byteBuffer.position() < n2) {
            return null;
        }
        int n6 = 4;
        if (n5 == 7) {
            n6 = 8;
        }
        int n7 = n2 / n6;
        this._fdata = new float[n7];
        for (int i = 0; i < n7; ++i) {
            this._fdata[i] = n5 == 7 ? (float)byteBuffer.getDouble() : byteBuffer.getFloat();
        }
        return new FloatSample(l, n4, this._fdata);
    }
}

