/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.nidas.apps.cockpit.ui;

import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QCheckBox;
import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QCursor;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QFrame;
import com.trolltech.qt.gui.QGroupBox;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QRadioButton;
import com.trolltech.qt.gui.QTextEdit;
import com.trolltech.qt.gui.QVBoxLayout;
import edu.ucar.nidas.core.UdpFeed;
import edu.ucar.nidas.core.UdpFeedFinder;
import edu.ucar.nidas.core.UdpFeedInf;
import edu.ucar.nidas.ui.TextClient;
import edu.ucar.nidas.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ServLookup
extends QDialog {
    private String _inputServ = "localhost";
    private int _port = 30000;
    private String _multiServ = "239.0.0.10";
    private int _ttl;
    private UdpFeedInf _udpFeedInf = null;
    private List<UdpFeedInf> _mUdpFeedInf = null;
    private UdpFeedFinder _udpFeedFinder = null;
    private UdpFeed _udpFeed;
    private String _prevServName;
    private String _initServ;
    private QRadioButton _mserv;
    private QRadioButton _sserv;
    private QRadioButton _rb;
    private QPushButton _bcancel;
    private QPushButton _bok;
    private QTextEdit _jtPort;
    private QTextEdit _jtmName;
    private QTextEdit _jtsName;
    private QTextEdit _debugTe;
    private QComboBox _jc;
    private QComboBox _cbData;
    private QLabel _jlServData;
    private QLabel _jlPort;
    private QCheckBox _cbDetail;
    private TextClient _txClient;

    public ServLookup(QFrame qFrame, String string) {
        this.setModal(true);
        if (string != null && string.length() > 0) {
            string.trim();
            String[] stringArray = string.split(":");
            if (stringArray != null && stringArray.length == 2) {
                this._inputServ = string.split(":")[0];
                this._port = Integer.valueOf(string.split(":")[1].trim());
            }
            if (stringArray != null && stringArray.length == 1) {
                this._inputServ = string;
            }
        }
        this.createComp();
    }

    public UdpFeed getUdpFeed() {
        return this._udpFeed;
    }

    public String getProjectName() {
        if (this._udpFeedInf != null) {
            return this._udpFeedInf.getProjectName();
        }
        return null;
    }

    private void toggleUI() {
        this._bok.setText(" Ok   ");
        this._mserv.setEnabled(false);
        this._sserv.setEnabled(false);
        this._jtPort.setEnabled(false);
        this._jtmName.setEnabled(false);
        this._jtsName.setEnabled(false);
        this._jc.setEnabled(false);
        this._jlPort.setEnabled(false);
        this._jlServData.setVisible(true);
    }

    private String getServName() {
        this._initServ = null;
        if (this._sserv.isChecked()) {
            this._initServ = this._inputServ = this._jtsName.toPlainText().trim();
        } else if (this._mserv.isChecked()) {
            this._initServ = this._multiServ = this._jtmName.toPlainText().trim();
        }
        return this._initServ;
    }

    private int getPort() {
        this._port = Integer.valueOf(this._jtPort.toPlainText().trim());
        return this._port;
    }

    private int getTTL() {
        this._ttl = this._jc.currentIndex() + 1;
        return this._ttl;
    }

    public void createComp() {
        this.setWindowTitle("     Select a network connection type ");
        QVBoxLayout qVBoxLayout = new QVBoxLayout();
        QGroupBox qGroupBox = new QGroupBox();
        QVBoxLayout qVBoxLayout2 = new QVBoxLayout();
        QHBoxLayout qHBoxLayout = new QHBoxLayout();
        this._mserv = new QRadioButton("Multi-cast");
        this._mserv.clicked.connect(this, "pressRMServ()");
        qHBoxLayout.addWidget(this._mserv);
        this._jtmName = new QTextEdit(this._multiServ);
        this._jtmName.setMaximumSize(200, 30);
        this._jtmName.adjustSize();
        qHBoxLayout.addWidget(this._jtmName);
        this._jc = new QComboBox();
        for (int i = 1; i <= 3; ++i) {
            this._jc.addItem(String.valueOf(i));
        }
        qHBoxLayout.addWidget(this._jc);
        qHBoxLayout.addStretch();
        Qt.Alignment alignment = new Qt.Alignment(new Qt.AlignmentFlag[0]);
        alignment.set(new Qt.AlignmentFlag[]{Qt.AlignmentFlag.AlignLeft});
        qVBoxLayout2.addLayout(qHBoxLayout);
        qHBoxLayout = new QHBoxLayout();
        this._sserv = new QRadioButton("Uni-cast  ");
        this._sserv.setChecked(true);
        this._sserv.clicked.connect(this, "pressRSServ()");
        qHBoxLayout.addWidget(this._sserv);
        this._jtsName = new QTextEdit(this._inputServ);
        this._jtsName.setMaximumSize(200, 30);
        this._jtsName.adjustSize();
        qHBoxLayout.addWidget(this._jtsName);
        qHBoxLayout.addWidget(new QLabel());
        qHBoxLayout.addStretch();
        qVBoxLayout2.addLayout(qHBoxLayout);
        qGroupBox.setLayout(qVBoxLayout2);
        qGroupBox.setTitle("Network CpConnection Type");
        qVBoxLayout.addWidget(qGroupBox);
        qHBoxLayout = new QHBoxLayout();
        this._jlPort = new QLabel("         Port#     ");
        qHBoxLayout.addWidget(this._jlPort);
        this._jtPort = new QTextEdit("" + this._port);
        this._jtPort.setMaximumSize(200, 30);
        this._jtPort.adjustSize();
        qHBoxLayout.addWidget(this._jtPort);
        qHBoxLayout.addWidget(new QLabel());
        qHBoxLayout.addStretch();
        qVBoxLayout.addLayout(qHBoxLayout);
        qHBoxLayout = new QHBoxLayout();
        qHBoxLayout.addWidget(new QLabel());
        qVBoxLayout.addLayout(qHBoxLayout);
        qHBoxLayout = new QHBoxLayout();
        this._jlServData = new QLabel("Server Option:");
        this._jlServData.setVisible(false);
        qHBoxLayout.addWidget(this._jlServData);
        this._cbData = new QComboBox();
        this._cbData.setVisible(false);
        qHBoxLayout.addWidget(this._cbData);
        qVBoxLayout.addItem(qHBoxLayout);
        this._cbDetail = new QCheckBox("Display CpConnection Details");
        this._cbDetail.setChecked(false);
        this._cbDetail.clicked.connect(this, "connDetail()");
        qVBoxLayout.addWidget(this._cbDetail);
        this._debugTe = new QTextEdit();
        this._debugTe.hide();
        qVBoxLayout.addWidget(this._debugTe);
        this._txClient = new TextClient(this._debugTe);
        qHBoxLayout = new QHBoxLayout();
        qHBoxLayout.addWidget(new QLabel());
        this._bok = new QPushButton("Search", this);
        this._bok.clicked.connect(this, "pressOk()");
        qHBoxLayout.addWidget(this._bok);
        this._bcancel = new QPushButton("Cancel", this);
        this._bcancel.clicked.connect(this, "pressCancel()");
        qHBoxLayout.addWidget(this._bcancel);
        qHBoxLayout.addWidget(new QLabel());
        qVBoxLayout.addItem(qHBoxLayout);
        this.setLayout(qVBoxLayout);
        this.setGeometry(400, 300, 400, 300);
        this.setVisible(true);
        this.exec();
    }

    void connDetail() {
        if (this._cbDetail.isChecked()) {
            this._debugTe.show();
            this.setGeometry(400, 300, 600, 400);
        } else {
            this._debugTe.hide();
            this.setGeometry(400, 300, 400, 300);
        }
    }

    void pressRMServ() {
        if (this._mserv.isChecked()) {
            this._sserv.setChecked(false);
        }
        if (!this._mserv.isChecked() && !this._sserv.isChecked()) {
            this._mserv.setChecked(true);
        }
    }

    void pressRSServ() {
        if (this._sserv.isChecked()) {
            this._mserv.setChecked(false);
        }
        if (!this._mserv.isChecked() && !this._sserv.isChecked()) {
            this._sserv.setChecked(true);
        }
    }

    void pressOk() {
        this.setCursor(new QCursor(Qt.CursorShape.WaitCursor));
        Util._txClient = this._txClient;
        if (this._bok.text().trim().equals("Search")) {
            this.searchServ();
            if (this._udpFeedInf != null) {
                Util.prtDbg("only one _servIp= " + this._udpFeedInf.getServ());
                this.buildDataFeed();
                Util._txClient = null;
                this.close();
            }
        } else {
            if (this._udpFeedInf == null && this._cbData.isVisible()) {
                this._udpFeedInf = this._mUdpFeedInf.get(this._cbData.currentIndex());
                this._prevServName = this._udpFeedInf.getServ();
            }
            this.buildDataFeed();
            Util._txClient = null;
            this.close();
        }
        Util._txClient = null;
        this.setCursor(new QCursor(Qt.CursorShape.ArrowCursor));
    }

    void pressCancel() {
        this.close();
    }

    void pressRb() {
        Util.debugConnct = !this._rb.isChecked() ? null : Util.debugConnct + "Enable connection debug";
    }

    private void searchServ() {
        int n = this.getTTL();
        String string = this.getServName();
        int n2 = this.getPort();
        this._udpFeedFinder = new UdpFeedFinder();
        this._udpFeedInf = null;
        Util.prtDbg(" connOpt =" + string + "  " + n2 + " " + n);
        try {
            this._mUdpFeedInf = this._udpFeedFinder.findServers(string, n2);
        }
        catch (IOException iOException) {
            Util.prtException(iOException, "\n searchServ() exception - ");
            this._udpFeedFinder.closeSocket();
            return;
        }
        if (this._mUdpFeedInf == null || this._mUdpFeedInf.size() == 0) {
            Util.prtErr("No server found...");
            return;
        }
        if (this._mUdpFeedInf.size() == 1) {
            this._udpFeedInf = this._mUdpFeedInf.get(0);
            return;
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this._mUdpFeedInf.size(); ++i) {
            this._cbData.addItem(this._mUdpFeedInf.get(i).getUserServInf());
        }
        this._cbData.setVisible(true);
        this.toggleUI();
    }

    private void buildDataFeed() {
        Util.prtDbg(" connOpt-buildDataFeed  = udpFeedFinder=" + this._udpFeedFinder.getServAddr().getHostName() + "\n _udpFeedInf=" + this._udpFeedInf.getUDPPort());
        this._udpFeed = new UdpFeed(this._udpFeedFinder, this._udpFeedInf);
    }

    public UdpFeed reconnectUdpFeeder() {
        this._udpFeedFinder.closeSocket();
        this._udpFeed.closeSocket();
        this._mUdpFeedInf.clear();
        this._udpFeedFinder = new UdpFeedFinder();
        this._udpFeedInf = null;
        this._mUdpFeedInf = new ArrayList<UdpFeedInf>();
        Util.prtDbg(" connOpt-reconnection  =" + this._initServ + "  " + this._port + " " + this._ttl);
        try {
            this._mUdpFeedInf.addAll(this._udpFeedFinder.findServers(this._initServ, this._port));
        }
        catch (Exception exception) {
            Util.prtException(exception, "\n searchServ() exception ");
            this._udpFeedFinder.closeSocket();
            this._udpFeedFinder = null;
            return null;
        }
        if (this._mUdpFeedInf == null || this._mUdpFeedInf.size() == 0) {
            Util.prtDbg(" reconnect--No server found...");
            return null;
        }
        if (this._mUdpFeedInf.size() == 1) {
            this._udpFeedInf = this._mUdpFeedInf.get(0);
        }
        if (this._udpFeedInf == null) {
            for (int i = 0; i < this._mUdpFeedInf.size(); ++i) {
                if (!this._mUdpFeedInf.get(i).getServ().equals(this._prevServName)) continue;
                this._udpFeedInf = this._mUdpFeedInf.get(i);
                break;
            }
        }
        if (this._udpFeedInf == null) {
            return null;
        }
        Util.prtDbg(" connOpt-reconnect-buildDataFeed  = udpFeedFinder=" + this._udpFeedFinder.getServAddr().getHostName() + "\n udpFeedInf=" + this._udpFeedInf.getUDPPort());
        this.buildDataFeed();
        return this._udpFeed;
    }
}

