/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.nidas.apps.cockpit.ui;

import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QTabWidget;
import com.trolltech.qt.gui.QTextEdit;
import com.trolltech.qt.gui.QVBoxLayout;
import edu.ucar.nidas.util.Util;

public class NoDataTimeout
extends QDialog {
    int _tmSec;
    QTextEdit _teTm;

    public NoDataTimeout(QTabWidget qTabWidget, int n) {
        this.setModal(true);
        this._tmSec = n;
        this.createComp();
    }

    public int getNewTimeSec() {
        return this._tmSec;
    }

    private void createComp() {
        this.setWindowTitle("   Enter a New No-Data Timeout  ");
        QVBoxLayout qVBoxLayout = new QVBoxLayout();
        QHBoxLayout qHBoxLayout = new QHBoxLayout();
        qHBoxLayout.addWidget(new QLabel("New Time(Seconds):"));
        this._teTm = new QTextEdit("" + this._tmSec);
        this._teTm.setMaximumSize(100, 30);
        qHBoxLayout.addWidget(this._teTm);
        qVBoxLayout.addLayout(qHBoxLayout);
        qHBoxLayout = new QHBoxLayout();
        qHBoxLayout.addWidget(new QLabel());
        QPushButton qPushButton = new QPushButton("Ok", this);
        qPushButton.clicked.connect(this, "pressOk()");
        qHBoxLayout.addWidget(qPushButton);
        QPushButton qPushButton2 = new QPushButton("Cancel", this);
        qPushButton2.clicked.connect(this, "pressCancel()");
        qHBoxLayout.addWidget(qPushButton2);
        qHBoxLayout.addWidget(new QLabel());
        qVBoxLayout.addItem(qHBoxLayout);
        this.setLayout(qVBoxLayout);
        this.setGeometry(400, 300, 300, 100);
        this.setVisible(true);
        this.exec();
    }

    private void pressOk() {
        String string = this._teTm.toPlainText().trim();
        if (string == null) {
            Util.prtErr("Null string " + this.getClass().getName());
            return;
        }
        int n = Integer.parseInt(string);
        if (n < 0) {
            Util.prtErr("The time should be bigger than 0...");
            this._teTm.setText("" + this._tmSec);
            this._teTm.setFocus();
            return;
        }
        this._tmSec = n;
        this.close();
    }

    private void pressCancel() {
        this._tmSec = -1;
        this.close();
    }
}

