/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.nidas.apps.cockpit.ui;

import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QTabWidget;
import com.trolltech.qt.gui.QTextEdit;
import com.trolltech.qt.gui.QVBoxLayout;
import edu.ucar.nidas.util.Util;

public class NewTimeMSec
extends QDialog {
    int _tmMSec;
    QTextEdit _teTm;

    public NewTimeMSec(QTabWidget qTabWidget, int n) {
        this.setModal(true);
        this._tmMSec = n;
        this.createComp();
    }

    public int getNewTimeMSec() {
        return this._tmMSec;
    }

    private void createComp() {
        this.setWindowTitle("   Enter a New Time Range   ");
        QVBoxLayout qVBoxLayout = new QVBoxLayout();
        QHBoxLayout qHBoxLayout = new QHBoxLayout();
        qHBoxLayout.addWidget(new QLabel("New Time Range (Seconds):"));
        this._teTm = new QTextEdit("" + this._tmMSec / 1000);
        this._teTm.setMaximumSize(100, 30);
        qHBoxLayout.addWidget(this._teTm);
        qVBoxLayout.addLayout(qHBoxLayout);
        qHBoxLayout = new QHBoxLayout();
        qHBoxLayout.addWidget(new QLabel());
        QPushButton qPushButton = new QPushButton("Ok", this);
        qPushButton.clicked.connect(this, "pressOk()");
        qHBoxLayout.addWidget(qPushButton);
        QPushButton qPushButton2 = new QPushButton("Cancel", this);
        qPushButton2.clicked.connect(this, "pressCancel()");
        qHBoxLayout.addWidget(qPushButton2);
        qHBoxLayout.addWidget(new QLabel());
        qVBoxLayout.addItem(qHBoxLayout);
        this.setLayout(qVBoxLayout);
        this.setGeometry(400, 300, 300, 100);
        this.setVisible(true);
        this.exec();
    }

    private void pressOk() {
        String string = this._teTm.toPlainText().trim();
        if (string == null) {
            Util.prtErr("Null string " + this.getClass().getName());
            return;
        }
        int n = Integer.parseInt(string);
        if (n % 60 != 0) {
            Util.prtErr("The time-span has to be in minutes\n For example: 60, 120, 180...");
            this._teTm.setText("" + this._tmMSec / 1000);
            this._teTm.setFocus();
            return;
        }
        this._tmMSec = n * 1000;
        this.close();
    }

    private void pressCancel() {
        this._tmMSec = -1;
        this.close();
    }
}

