/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.nidas.apps.cockpit.ui;

import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QAbstractItemView;
import com.trolltech.qt.gui.QBrush;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QCursor;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QFrame;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QPalette;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QTableWidget;
import com.trolltech.qt.gui.QTableWidgetItem;
import com.trolltech.qt.gui.QTextEdit;
import com.trolltech.qt.gui.QVBoxLayout;
import edu.ucar.nidas.apps.cockpit.ui.CockPit;
import edu.ucar.nidas.apps.cockpit.ui.UIUtil;
import edu.ucar.nidas.model.Var;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtLookup
extends QDialog {
    private List<Var> _vars = new ArrayList<Var>();
    private List<Var> _selvars = new ArrayList<Var>();
    private List<Integer> _selectedIdxs = new ArrayList<Integer>();
    private QTableWidget _tbl;
    private QTextEdit _tedit;
    private QBrush _pgreen = new QBrush(QColor.green);
    private QBrush _pblack = new QBrush(QColor.black);
    private String yesstr = "Y";
    private String nostr = "N";
    private CockPit _cpit;
    private UIUtil _uU = new UIUtil();

    public HtLookup(QFrame qFrame, CockPit cockPit, List<Var> list) {
        this.setModal(true);
        this._cpit = cockPit;
        this._vars = this._uU.getSortedVarsByHeight(list);
        this.createComp();
        if (this._tbl == null) {
            this.close();
        }
        this.populateTbl();
        this._tbl.setSelectionBehavior(QAbstractItemView.SelectionBehavior.SelectRows);
        this._tbl.setSelectionMode(QAbstractItemView.SelectionMode.MultiSelection);
        this._tbl.setMinimumSize(390, 350);
        this._tbl.setColumnWidth(0, 250);
        this._tbl.setColumnWidth(1, 70);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(" Varaibles");
        arrayList.add(" Status");
        this._tbl.setHorizontalHeaderLabels(arrayList);
    }

    public List<Var> getSelVars() {
        return this._selvars;
    }

    private void createComp() {
        this.setWindowTitle("Table to Select Variables");
        this.setCursor(new QCursor(Qt.CursorShape.WaitCursor));
        QFrame qFrame = new QFrame();
        qFrame.setMinimumSize(150, 350);
        QVBoxLayout qVBoxLayout = new QVBoxLayout();
        qVBoxLayout.addWidget(new QLabel());
        QFrame qFrame2 = new QFrame();
        QHBoxLayout qHBoxLayout = new QHBoxLayout();
        qHBoxLayout.setMargin(0);
        this._tedit = new QTextEdit();
        this._tedit.setMaximumSize(120, 30);
        QPalette qPalette = new QPalette(QColor.green);
        this._tedit.setPalette(qPalette);
        this._tedit.setLineWrapColumnOrWidth(200);
        this._tedit.textChanged.connect(this, "searchBegin()");
        QLabel qLabel = new QLabel("Search:");
        qLabel.setTextFormat(Qt.TextFormat.RichText);
        qHBoxLayout.addWidget(qLabel);
        qHBoxLayout.addWidget(this._tedit);
        qFrame2.setLayout(qHBoxLayout);
        qFrame2.setPalette(qPalette);
        qVBoxLayout.addWidget(qFrame2);
        qVBoxLayout.addWidget(new QLabel());
        QPushButton qPushButton = new QPushButton("toggle");
        qPushButton.clicked.connect(this, "toggleSelection()");
        qVBoxLayout.addWidget(qPushButton);
        qFrame2 = new QFrame();
        qHBoxLayout = new QHBoxLayout();
        qPushButton = new QPushButton("SelectAll");
        qPushButton.clicked.connect(this, "selectAll()");
        qHBoxLayout.addWidget(qPushButton);
        qPushButton = new QPushButton("DeselectAll");
        qPushButton.clicked.connect(this, "deselectAll()");
        qHBoxLayout.addWidget(qPushButton);
        qFrame2.setLayout(qHBoxLayout);
        qVBoxLayout.addWidget(qFrame2);
        qVBoxLayout.addWidget(new QLabel());
        qVBoxLayout.addWidget(new QLabel());
        qVBoxLayout.addWidget(new QLabel());
        qVBoxLayout.addWidget(new QLabel());
        qVBoxLayout.addWidget(new QLabel());
        qVBoxLayout.addWidget(new QLabel());
        qVBoxLayout.addWidget(new QLabel());
        qFrame2 = new QFrame();
        qHBoxLayout = new QHBoxLayout();
        qPushButton = new QPushButton("    Ok    ");
        qPushButton.clicked.connect(this, "pressOk()");
        qHBoxLayout.addWidget(qPushButton);
        qPushButton = new QPushButton("Cancel");
        qPushButton.clicked.connect(this, "pressCancel()");
        qHBoxLayout.addWidget(qPushButton);
        qFrame2.setLayout(qHBoxLayout);
        qVBoxLayout.addWidget(qFrame2);
        QHBoxLayout qHBoxLayout2 = new QHBoxLayout();
        this._tbl = new QTableWidget(20, 2, null);
        qFrame.setLayout(qVBoxLayout);
        qHBoxLayout2.addWidget(this._tbl);
        qHBoxLayout2.addWidget(qFrame);
        this.setLayout(qHBoxLayout2);
        this.setMinimumSize(600, 350);
        this.show();
        this.setCursor(new QCursor(Qt.CursorShape.ArrowCursor));
    }

    private void populateTbl() {
        this.setCursor(new QCursor(Qt.CursorShape.WaitCursor));
        this._tbl.clear();
        int n = this._vars.size();
        this._tbl.setRowCount(n);
        for (int i = 0; i < n; ++i) {
            Var var = this._vars.get(i);
            String string = var.getName();
            QTableWidgetItem qTableWidgetItem = new QTableWidgetItem(this.nostr);
            qTableWidgetItem.setTextAlignment(12);
            this._tbl.setItem(i, 0, new QTableWidgetItem(string));
            this._tbl.setItem(i, 1, qTableWidgetItem);
            this._selectedIdxs.add(new Integer(i));
        }
        this.setCursor(new QCursor(Qt.CursorShape.ArrowCursor));
    }

    private void populateStatusTbl() {
        this.setCursor(new QCursor(Qt.CursorShape.WaitCursor));
        int n = this._tbl.rowCount();
        this._selectedIdxs.clear();
        for (int i = 1; i <= n; ++i) {
            this._tbl.setRowHidden(i, false);
            this._selectedIdxs.add(new Integer(i));
        }
        this.setCursor(new QCursor(Qt.CursorShape.ArrowCursor));
    }

    private void pressCancel() {
        this._tbl.clear();
        this._selvars = null;
        this.close();
    }

    private void pressOk() {
        this.setCursor(new QCursor(Qt.CursorShape.WaitCursor));
        this._selvars.clear();
        int n = this._tbl.rowCount();
        for (int i = 0; i < n; ++i) {
            if (!this._tbl.item(i, 1).text().equals(this.yesstr)) continue;
            this._selvars.add(this._vars.get(i));
        }
        if (this._selvars.size() > 0) {
            this._cpit._centWidget.addNewPage(this._selvars, this._selvars.get(0).getName());
        }
        this.close();
        this.setCursor(new QCursor(Qt.CursorShape.ArrowCursor));
    }

    private void selectAll() {
        this.setCursor(new QCursor(Qt.CursorShape.WaitCursor));
        int n = this._tbl.rowCount();
        for (int i = 0; i < n; ++i) {
            QTableWidgetItem qTableWidgetItem = this._tbl.item(i, 1);
            if (qTableWidgetItem == null) {
                return;
            }
            if (!this._selectedIdxs.contains(new Integer(i))) continue;
            qTableWidgetItem.setText(this.yesstr);
            qTableWidgetItem.setForeground(this._pgreen);
        }
        this.setCursor(new QCursor(Qt.CursorShape.ArrowCursor));
    }

    private void deselectAll() {
        this.setCursor(new QCursor(Qt.CursorShape.WaitCursor));
        int n = this._tbl.rowCount();
        for (int i = 0; i < n; ++i) {
            QTableWidgetItem qTableWidgetItem = this._tbl.item(i, 1);
            if (qTableWidgetItem == null) {
                return;
            }
            if (!this._selectedIdxs.contains(new Integer(i))) continue;
            qTableWidgetItem.setText(this.nostr);
            qTableWidgetItem.setForeground(this._pblack);
        }
        this.setCursor(new QCursor(Qt.CursorShape.ArrowCursor));
    }

    private void searchBegin() {
        int n;
        int n2;
        String string = this._tedit.toPlainText().trim();
        int n3 = string.length();
        if (n3 <= 0) {
            this.populateStatusTbl();
            return;
        }
        for (n2 = 0; n2 < string.length(); ++n2) {
            n = string.charAt(n2);
            char c = '.';
            if (Character.isDigit((char)n) || Character.isDefined(c)) continue;
            return;
        }
        if (String.valueOf(string.charAt(n3 - 1)).equals(Character.valueOf('.'))) {
            string = string + "0";
        }
        string = string + "m";
        this.setCursor(new QCursor(Qt.CursorShape.WaitCursor));
        n2 = this._vars.size();
        this._selectedIdxs.clear();
        for (n = 0; n < n2; ++n) {
            String string2 = this._vars.get(n).getName();
            if (string2.length() < string.length()) {
                this._tbl.setRowHidden(n, true);
                continue;
            }
            int n4 = string2.indexOf(string);
            if (n4 > -1) {
                this._tbl.setRowHidden(n, false);
                this._selectedIdxs.add(new Integer(n));
                continue;
            }
            this._tbl.setRowHidden(n, true);
        }
        this.setCursor(new QCursor(Qt.CursorShape.ArrowCursor));
    }

    private void toggleSelection() {
        this.setCursor(new QCursor(Qt.CursorShape.WaitCursor));
        int n = this._tbl.rowCount();
        for (int i = 0; i < n; ++i) {
            QTableWidgetItem qTableWidgetItem = this._tbl.item(i, 1);
            if (qTableWidgetItem == null) {
                return;
            }
            if (!qTableWidgetItem.isSelected() || !this._selectedIdxs.contains(new Integer(i))) continue;
            if (qTableWidgetItem.text().equals(this.yesstr)) {
                qTableWidgetItem.setText(this.nostr);
                qTableWidgetItem.setForeground(this._pblack);
                continue;
            }
            qTableWidgetItem.setText(this.yesstr);
            qTableWidgetItem.setForeground(this._pgreen);
        }
        this.setCursor(new QCursor(Qt.CursorShape.ArrowCursor));
    }
}

