/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.nidas.apps.cockpit.ui;

import com.trolltech.qt.core.QPoint;
import com.trolltech.qt.core.QRectF;
import com.trolltech.qt.core.QSize;
import com.trolltech.qt.core.QTimer;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QColorDialog;
import com.trolltech.qt.gui.QFont;
import com.trolltech.qt.gui.QMenu;
import com.trolltech.qt.gui.QMouseEvent;
import com.trolltech.qt.gui.QPaintEvent;
import com.trolltech.qt.gui.QPainter;
import com.trolltech.qt.gui.QPen;
import com.trolltech.qt.gui.QPixmap;
import com.trolltech.qt.gui.QResizeEvent;
import com.trolltech.qt.gui.QSizePolicy;
import com.trolltech.qt.gui.QWidget;
import edu.ucar.nidas.apps.cockpit.ui.CockPit;
import edu.ucar.nidas.apps.cockpit.ui.GaugePage;
import edu.ucar.nidas.apps.cockpit.ui.NoDataTimeout;
import edu.ucar.nidas.apps.cockpit.ui.RescaleDialog;
import edu.ucar.nidas.core.FloatSample;
import edu.ucar.nidas.model.Var;
import edu.ucar.nidas.util.Util;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gauge
extends QWidget {
    GaugePage _parent;
    int _reductionTm = 1000;
    int _tmoutMax = 300;
    boolean _noDataPaint = false;
    long _lastTm = -1L;
    long _prevTtag = -1L;
    int _prevXp = -1;
    QTimer _tm;
    boolean _gautoScale = false;
    List<QPoint> _pts = new ArrayList<QPoint>();
    float[] _maxmin;
    QPixmap _pixmap;
    QPixmap _historyPixmap;
    QPixmap _noDataPixmap;
    QPainter _painter;
    QPainter _historyPainter;
    Var _var;
    public String _label;
    String _units;
    boolean _dynamic;
    float _ymin;
    float _ymax;
    long _xmin;
    int _xwidth;
    float _xscale = 1.0f;
    float _yscale = 1.0f;
    float _ticDelta;
    int _xmouse;
    int _ymouse;
    int _pwidth;
    int _pheight;
    QColor _cColor = CockPit.gdefCColor;
    QColor _hColor = CockPit.gdefHColor;
    QColor _bgColor = CockPit.gdefBColor;

    private int xpixel(long l) {
        return Math.round((float)l * this._xscale);
    }

    private int ypixel(float f) {
        return Math.round((this._ymax - f) * this._yscale);
    }

    public Gauge(GaugePage gaugePage, int n, int n2, int n3, Var var) {
        this._parent = gaugePage;
        this._xmin = 0L;
        this._xwidth = n3;
        this._reductionTm = gaugePage.getReductionPeriod();
        this.setMinimumSize(n, n2);
        this.resize(n, n2);
        this._var = var;
        this._label = var.getName();
        this._units = var.getUnits();
        this._dynamic = var.getDynamic();
        this._pwidth = n;
        this._pheight = n2;
        this.calTics(var.getMax(), var.getMin());
        this.rescale(this.size());
        this.initPixmaps();
        this._cColor = gaugePage.getCColor();
        this._hColor = gaugePage.getHColor();
        this._bgColor = gaugePage.getBGColor();
        this._lastTm = System.currentTimeMillis();
        this._tm = new QTimer();
        this._tm.timeout.connect(this, "timeout()");
        int n4 = this._tmoutMax * 1000 / 10;
        this._tm.start(n4);
    }

    public Var getVar() {
        return this._var;
    }

    public GaugePage getPage() {
        return this._parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoResize() {
        Gauge gauge = this;
        synchronized (gauge) {
            QSize qSize = this._parent.getPlots().get(0).size();
            this.resize(qSize.width(), qSize.height());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewTimeMSec(int n) {
        if (n == this._xwidth) {
            return;
        }
        Gauge gauge = this;
        synchronized (gauge) {
            this._xwidth = n;
            QSize qSize = this._parent.getPlots().get(0).size();
            this.resize(qSize);
            this.rescale(qSize);
            this.initPixmaps();
            this._pts.clear();
            this._maxmin = null;
        }
    }

    public void setNoDataTmout() {
        NoDataTimeout noDataTimeout = new NoDataTimeout(null, this._tmoutMax);
        int n = noDataTimeout.getNewTimeSec();
        if (n <= 0 || this._tmoutMax == n) {
            return;
        }
        this.setNoDataTmout(n);
    }

    public void setNoDataTmout(int n) {
        if (this._tmoutMax == n) {
            return;
        }
        this._tmoutMax = n;
        this._tm.stop();
        this._tm.start(n * 1000 / 6);
        this._noDataPaint = false;
        this._parent.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescale(QSize qSize) {
        Gauge gauge = this;
        synchronized (gauge) {
            this._pheight = qSize.height();
            this._pwidth = qSize.width();
            this._xscale = (float)this._pwidth / (float)this._xwidth;
            this._yscale = this.getYScale();
            this._prevTtag = -1L;
            this._prevXp = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintLines() {
        Gauge gauge = this;
        synchronized (gauge) {
            if (this._painter != null) {
                this._painter.drawLinesFromPoints(this._pts);
                this.drawOutliners(this._pts);
                this.update();
            }
        }
    }

    public void cleanupHistory() {
        this.initPixmaps();
        this.paintLines();
    }

    public void changeCColor(QColor qColor) {
        this._cColor = qColor;
        this.resetPainter();
        this.paintLines();
    }

    public void changeHColor(QColor qColor) {
        this._hColor = qColor;
        this.initPixmaps();
        this.paintLines();
    }

    public void changeBGColor(QColor qColor) {
        this._bgColor = qColor;
        this.initPixmaps();
        this.paintLines();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(FloatSample floatSample, int n) {
        Gauge gauge = this;
        synchronized (gauge) {
            int n2;
            long l = floatSample.getTimeTag();
            if (this._xmin == 0L) {
                this._xmin = l - l % (long)this._xwidth;
            }
            if ((n2 = (int)(l - this._xmin)) > this._xwidth) {
                this.drawHistData();
                this.resetPainter();
                this._pts.clear();
                this._maxmin = null;
                this._xmin = l - l % (long)this._xwidth;
                n2 = (int)(l - this._xmin);
            }
            int n3 = this.xpixel(n2);
            String string = this._var.getName();
            float f = floatSample.getData(n);
            float f2 = floatSample.getData(n + 1);
            if (!Float.isNaN(f) && !Float.isNaN(f2)) {
                int n4;
                this._noDataPaint = false;
                this._lastTm = l;
                int n5 = this.ypixel(f);
                if (n5 == (n4 = this.ypixel(f2))) {
                    ++n4;
                }
                ArrayList<QPoint> arrayList = new ArrayList<QPoint>();
                int n6 = n3 - this._prevXp;
                if (this._prevTtag > 0L && l - this._prevTtag == (long)this._reductionTm) {
                    for (int i = 0; i < n6; ++i) {
                        int n7 = this._prevXp + 1 + i;
                        arrayList.add(new QPoint(n7, n5));
                        arrayList.add(new QPoint(n7, n4));
                    }
                } else {
                    arrayList.add(new QPoint(n3, n5));
                    arrayList.add(new QPoint(n3, n4));
                }
                if (this._painter != null) {
                    this._painter.drawLinesFromPoints(arrayList);
                    this.drawOutliners(arrayList);
                } else {
                    this._parent._parent._parent._cpConn.getStatusBarClient().receive(" plot=" + this._var.getName() + " in recieve get null painter.", 10000);
                }
                this._pts.addAll(arrayList);
                if (this._maxmin == null) {
                    this._maxmin = new float[2];
                    this._maxmin[0] = f2;
                    this._maxmin[1] = f;
                }
                if (f2 > this._maxmin[0]) {
                    this._maxmin[0] = f2;
                }
                if (f < this._maxmin[1]) {
                    this._maxmin[1] = f;
                }
                this._prevTtag = l;
                this._prevXp = n3;
                this.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resizeEvent(QResizeEvent qResizeEvent) {
        if (this._parent.getPolicy() == QSizePolicy.Policy.Fixed) {
            return;
        }
        Gauge gauge = this;
        synchronized (gauge) {
            this.rescale(qResizeEvent.size());
            this.initPixmaps();
            this._pts.clear();
            this._maxmin = null;
        }
    }

    private void timeout() {
        long l = System.currentTimeMillis();
        if ((l - this._lastTm) / 1000L < (long)this._tmoutMax) {
            return;
        }
        this._noDataPaint = true;
        this.repaint();
    }

    @Override
    public void paintEvent(QPaintEvent qPaintEvent) {
        QPainter qPainter = null;
        if (!this._pixmap.isNull()) {
            qPainter = new QPainter(this);
            qPainter.drawPixmap(0, 0, this._pixmap);
            if (this._noDataPaint) {
                qPainter.setPen(QColor.lightGray);
                qPainter.drawText(this.width() / 2, this.height() / 2, "RIP");
            }
        }
        if (qPainter != null) {
            qPainter.end();
        }
    }

    @Override
    public void mouseReleaseEvent(QMouseEvent qMouseEvent) {
        if (qMouseEvent.button() == Qt.MouseButton.RightButton) {
            QMenu qMenu = new QMenu("");
            QMenu qMenu2 = qMenu.addMenu("Plot_Option");
            QMenu qMenu3 = qMenu2.addMenu("Color");
            qMenu3.addAction("&CleanUp_History", this, "cleanupLocalHistory()");
            qMenu3.addAction("Co&lor_Current", this, "changeLocalCColor()");
            qMenu3.addAction("Color_&History", this, "changeLocalHColor()");
            qMenu3.addAction("Color_&BackGround", this, "changeLocalBGColor()");
            QMenu qMenu4 = qMenu2.addMenu("Scale");
            qMenu4.addAction("&ManuallyScale_Plot", this, "changeYMaxMin()");
            qMenu4.addAction("&AutoScale_Plot", this, "forcedAutoScalePlot()");
            qMenu2.addAction("SetNoDataTmout", this, "setNoDataTmout()");
            qMenu2.addAction("&AutoResize", this, "autoResize()");
            qMenu2.addAction("&DeletePlot", this, "deletePlot()");
            this._xmouse = qMouseEvent.globalX();
            this._ymouse = qMouseEvent.globalY();
            qMenu2.popup(new QPoint(this._xmouse, this._ymouse));
        }
    }

    private void deletePlot() {
        this._parent.deleteIt(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawHistData() {
        Gauge gauge = this;
        synchronized (gauge) {
            if (this._historyPainter != null) {
                this._historyPainter.drawLinesFromPoints(this._pts);
            }
        }
    }

    public void initPixmaps() {
        this._historyPixmap = new QPixmap(this.size().width(), this.size().height());
        this._historyPixmap.fill(this._bgColor);
        this._noDataPixmap = this._historyPixmap.copy();
        this.resetHistoryPainter();
        this.resetPainter();
        if (this._noDataPixmap.isNull()) {
            return;
        }
        QPainter qPainter = new QPainter(this._noDataPixmap);
        QPen qPen = qPainter.pen();
        qPainter.setPen(QColor.lightGray);
        qPainter.drawText(this.width() / 2, this.height() / 2, "RIP");
        qPainter.setPen(qPen);
        this.paintText(qPainter);
        qPainter.end();
    }

    private void changeLocalCColor() {
        QColor qColor = QColorDialog.getColor(this._cColor);
        if (qColor.value() == 0) {
            return;
        }
        this._cColor = qColor;
        this.changeCColor(this._cColor);
    }

    private void changeLocalHColor() {
        QColor qColor = QColorDialog.getColor(this._hColor);
        if (qColor.value() == 0) {
            return;
        }
        this._hColor = qColor;
        this.changeHColor(this._hColor);
    }

    private void changeLocalBGColor() {
        QColor qColor = QColorDialog.getColor(this._bgColor);
        if (qColor.value() == 0) {
            return;
        }
        this._bgColor = qColor;
        this.changeBGColor(this._bgColor);
    }

    private void cleanupLocalHistory() {
        this.cleanupHistory();
    }

    private void changeYMaxMin() {
        RescaleDialog rescaleDialog = new RescaleDialog(this._ymax, this._ymin, this._xmouse, this._ymouse);
        if (!rescaleDialog.getOk()) {
            return;
        }
        if (rescaleDialog.getMax() <= rescaleDialog.getMin()) {
            Util.prtErr("Y-axis-Max is smaller than Y-axis-Min");
            return;
        }
        this.changeYMaxMin(rescaleDialog.getMax(), rescaleDialog.getMin());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeYMaxMin(float f, float f2) {
        if (f == this._ymax && f2 == this._ymin) {
            return;
        }
        Gauge gauge = this;
        synchronized (gauge) {
            this._yscale = this.getYScale(f, f2);
            this._pts.clear();
            this._maxmin = null;
            this.initPixmaps();
        }
        this.repaint();
    }

    public void forcedAutoScalePlot() {
        this._gautoScale = false;
        this.autoScalePlot();
    }

    public void autoScalePlot(boolean bl) {
        this._gautoScale = bl;
        this.autoScalePlot();
        this._gautoScale = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoScalePlot() {
        Gauge gauge = this;
        synchronized (gauge) {
            boolean bl;
            if (this._pts == null || this._pts.size() < 1) {
                this._noDataPaint = true;
                this.repaint();
                return;
            }
            if (this._maxmin == null) {
                return;
            }
            float f = this._maxmin[0];
            float f2 = this._maxmin[1];
            float f3 = Math.abs(this._ymax - this._ymin) * 0.02f;
            boolean bl2 = bl = this._gautoScale && f2 > this._ymin + f3 && f < this._ymax - f3;
            if (bl) {
                return;
            }
            float f4 = Math.abs(f - f2);
            if ((double)f4 < 1.0) {
                boolean bl3 = bl = this._gautoScale && (f2 -= 5.0f) > this._ymin + f3 && (f += 5.0f) < this._ymax - f3;
                if (bl) {
                    return;
                }
            }
            this._yscale = this.getYScale(f, f2);
            this._pts.clear();
            this._maxmin = null;
            this.initPixmaps();
        }
        this.repaint();
    }

    public void removeSelf() {
        this._var.setDisplay(false);
        this._parent.removeGaugeFromWidget(this);
    }

    private void resetHistoryPainter() {
        if (this._historyPixmap.isNull()) {
            return;
        }
        if (this._historyPainter != null) {
            this._historyPainter.end();
        }
        this._historyPainter = new QPainter(this._historyPixmap);
        this._historyPainter.setPen(this._hColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetPainter() {
        if (this._historyPixmap.isNull()) {
            return;
        }
        Gauge gauge = this;
        synchronized (gauge) {
            if (this._painter != null) {
                this._painter.end();
            }
            this._pixmap = this._historyPixmap.copy();
            QPainter qPainter = new QPainter(this._pixmap);
            this.paintText(qPainter);
            qPainter.end();
            this._painter = new QPainter(this._pixmap);
            this._painter.setPen(this._cColor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintText(QPainter qPainter) {
        if (qPainter == null) {
            return;
        }
        Gauge gauge = this;
        synchronized (gauge) {
            int n;
            QFont qFont = qPainter.font();
            QPen qPen = qPainter.pen();
            double d = qFont.pointSizeF();
            QFont qFont2 = new QFont(qFont);
            int n2 = this.rect().height() / 10;
            int n3 = this.rect().width();
            qPainter.setPen(QColor.yellow);
            qFont2.setPointSizeF(d * 0.8);
            qPainter.setFont(qFont2);
            QRectF qRectF = new QRectF(0.0, 0.0, n3, n2);
            qPainter.drawText(this.rect(), Qt.AlignmentFlag.AlignRight.value(), this._label);
            qFont2.setPointSizeF(d * 0.75);
            qPainter.setFont(qFont2);
            qRectF = new QRectF(0.0, (double)this.rect().height() - qFont2.pointSizeF() * 1.5, n3 - 2, qFont2.pointSizeF() * 1.5);
            qPainter.drawText(qRectF, Qt.AlignmentFlag.AlignRight.value(), this._units);
            qRectF = new QRectF(5.0, 0.0, n3, this.rect().height());
            qPainter.drawText(qRectF, Qt.AlignmentFlag.AlignLeft.value(), this.getLabel(this._ymax));
            qRectF = new QRectF(5.0, (double)this.rect().height() - qFont2.pointSizeF() * 1.5, n3, qFont2.pointSizeF() * 1.5);
            qPainter.drawText(qRectF, Qt.AlignmentFlag.AlignLeft.value(), this.getLabel(this._ymin));
            qPainter.setFont(new QFont(qFont.family(), 5));
            int n4 = (int)((this._ymax - this._ymin) / this._ticDelta) - 1;
            for (n = 1; n <= n4; ++n) {
                int n5 = this.ypixel(this._ymax - (float)n * this._ticDelta);
                qPainter.drawLine(0, n5, 2, n5);
            }
            if (n4 % 2 == 1) {
                n = n4 / 2 + 1;
                this.paintLabel(n, qPainter);
            } else {
                n = n4 / 2;
                this.paintLabel(n, qPainter);
                n = n4 / 2 + 1;
                this.paintLabel(n, qPainter);
            }
            qPainter.setPen(qPen);
            qPainter.setFont(qFont);
        }
    }

    public void closePlot() {
        if (this._painter != null) {
            this._painter.end();
        }
        if (this._historyPainter != null) {
            this._historyPainter.end();
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintLabel(int n, QPainter qPainter) {
        Gauge gauge = this;
        synchronized (gauge) {
            float f = this._ymax - (float)n * this._ticDelta;
            int n2 = this.ypixel(f);
            qPainter.drawText(3, n2 + 2, this.getLabel(f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calTics(float f, float f2) {
        if (f <= f2) {
            this.setStatusBar("getTics(): The max is less or equal to min. Exit-calTics()", 10000);
            return;
        }
        double d = (f - f2) / 6.0f;
        double d2 = Math.floor(Math.log10(d));
        double d3 = Math.pow(10.0, d2);
        int n = (int)Math.ceil(d / d3);
        if (n > 5) {
            n = 10;
        } else if (n > 1) {
            n = 5;
        }
        Gauge gauge = this;
        synchronized (gauge) {
            this._ticDelta = (float)((double)n * d3);
            this._ymax = this.getMaxTick(f, this._ticDelta);
            this._ymin = this.getMinTick(f2, this._ticDelta);
        }
    }

    private float getMaxTick(float f, float f2) {
        return (float)Math.ceil(f / f2) * f2;
    }

    private float getMinTick(float f, float f2) {
        return (float)Math.floor(f / f2) * f2;
    }

    private String getLabel(float f) {
        String string = Float.toString(f).trim();
        if (string.endsWith(".0")) {
            return string.substring(0, string.length() - 2);
        }
        return string;
    }

    private void setStatusBar(String string, int n) {
        this._parent._parent._parent._cpConn.getStatusBarClient().receive(string, n);
    }

    private float getYScale(float f, float f2) {
        this.calTics(f, f2);
        return this.getYScale();
    }

    private float getYScale() {
        return (float)this._pheight / (this._ymax - this._ymin);
    }

    private void drawOutliners(List<QPoint> list) {
        for (int i = 0; i < list.size(); ++i) {
            float f = this._ymax - (float)list.get(i).y() / this._yscale;
            if (f > this._ymax && this._painter != null) {
                this._painter.setPen(QColor.red);
                this._painter.drawEllipse(list.get(i).x(), this.ypixel(this._ymax), 2, 2);
                this._painter.setPen(this._cColor);
            }
            if (!(f < this._ymin) || this._painter == null) continue;
            this._painter.setPen(QColor.red);
            this._painter.drawEllipse(list.get(i).x(), this.ypixel(this._ymin) - 3, 2, 2);
            this._painter.setPen(this._cColor);
        }
    }

    public float getYMax() {
        return this._ymax;
    }

    public float getYMin() {
        return this._ymin;
    }

    public int getNoDataTmout() {
        return this._tmoutMax;
    }

    public int getGaugeTimeMSec() {
        return this._xwidth;
    }

    public String getName() {
        return this._label;
    }

    public void setCColor(QColor qColor) {
        this.changeCColor(qColor);
    }

    public QColor getCColor() {
        return this._cColor;
    }

    public void setHColor(QColor qColor) {
        this.changeHColor(qColor);
    }

    public QColor getHColor() {
        return this._hColor;
    }

    public void setBGColor(QColor qColor) {
        this.changeBGColor(qColor);
    }

    public QColor getBGColor() {
        return this._bgColor;
    }

    public static class Transparency {
        public static Image makeColorTransparent(Image image, final Color color) {
            RGBImageFilter rGBImageFilter = new RGBImageFilter(){
                public int markerRGB;
                {
                    this.markerRGB = color.getRGB() | 0xFF000000;
                }

                public final int filterRGB(int n, int n2, int n3) {
                    if ((n3 | 0xFF000000) == this.markerRGB) {
                        return 0xFFFFFF & n3;
                    }
                    return n3;
                }
            };
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), rGBImageFilter);
            return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        }
    }
}

