/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.nidas.apps.cockpit.ui;

import com.trolltech.qt.core.QPoint;
import com.trolltech.qt.core.QTimer;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QAction;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QColorDialog;
import com.trolltech.qt.gui.QCursor;
import com.trolltech.qt.gui.QInputDialog;
import com.trolltech.qt.gui.QLineEdit;
import com.trolltech.qt.gui.QMenu;
import com.trolltech.qt.gui.QMouseEvent;
import com.trolltech.qt.gui.QSizePolicy;
import com.trolltech.qt.gui.QStackedLayout;
import com.trolltech.qt.gui.QTabWidget;
import com.trolltech.qt.gui.QWidget;
import edu.ucar.nidas.apps.cockpit.model.DataDescriptor;
import edu.ucar.nidas.apps.cockpit.model.config.CockpitConfig;
import edu.ucar.nidas.apps.cockpit.model.config.PlotConfig;
import edu.ucar.nidas.apps.cockpit.model.config.TabPageConfig;
import edu.ucar.nidas.apps.cockpit.model.config.UserConfig;
import edu.ucar.nidas.apps.cockpit.ui.CockPit;
import edu.ucar.nidas.apps.cockpit.ui.Gauge;
import edu.ucar.nidas.apps.cockpit.ui.GaugeDataClient;
import edu.ucar.nidas.apps.cockpit.ui.GaugePage;
import edu.ucar.nidas.apps.cockpit.ui.NewTimeMSec;
import edu.ucar.nidas.apps.cockpit.ui.NoDataTimeout;
import edu.ucar.nidas.apps.cockpit.ui.PostGaugePage;
import edu.ucar.nidas.apps.cockpit.ui.RescaleDialog;
import edu.ucar.nidas.apps.cockpit.ui.UIUtil;
import edu.ucar.nidas.model.Dsm;
import edu.ucar.nidas.model.Sample;
import edu.ucar.nidas.model.Var;
import edu.ucar.nidas.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CentTabWidget
extends QTabWidget {
    CockPit _parent = null;
    List<Sample> _samples = new ArrayList<Sample>();
    List<Dsm> _dsms = new ArrayList<Dsm>();
    List<GaugePage> _gaugePages = new ArrayList<GaugePage>(0);
    public static HashMap<Var, GaugeDataClient> _varToGdc = new HashMap();
    static HashMap<String, GaugePage> _nameToGaugepage = new HashMap();
    int _pidx = -1;
    QStackedLayout _stacked = new QStackedLayout();
    UIUtil _uU = new UIUtil();
    private QTimer _tm;
    private QTimer _ucftm;
    String _name;
    QTimer _cycleTm;
    int _cycleInt = 10;
    UserConfig _saveconfig = new UserConfig();
    UserConfig _openconfig = new UserConfig();

    public CentTabWidget(CockPit cockPit) {
        this._parent = cockPit;
        this.connectSlotsByName();
        this.setLayout(this._stacked);
        this.currentChanged.connect(this, "pageChanged()");
        this._cycleTm = new QTimer();
        this._cycleTm.timeout.connect(this, "cycleTimeout()");
    }

    public void createPrimaryGauges() {
        if (this._dsms == null || this._dsms.size() < 1) {
            return;
        }
        GaugePage gaugePage = null;
        for (int i = 0; i < this._dsms.size(); ++i) {
            Dsm dsm = this._dsms.get(i);
            if (dsm == null) continue;
            if (dsm.getSamples() == null || dsm.getSamples().isEmpty()) {
                Util.prtErr("dsm " + dsm.getName() + " contains empty samples. \nSkip creating plots ");
                continue;
            }
            Util.prtDbg("create-" + dsm.getName() + "-page");
            gaugePage = new GaugePage(this, dsm.getSamples(), dsm.getName());
            String string = "gdefBColor";
            if (i % 4 != 0) {
                string = string + (i % 4 + 1);
            }
            gaugePage.setBGColor(CockPit._orderToColor.get(string));
            if (gaugePage == null) {
                Util.prtDbg("Errors occured in creating " + dsm.getName() + " page");
                continue;
            }
            gaugePage.setGeometry(PageGeometry.x, PageGeometry.y, PageGeometry.w, PageGeometry.h);
            this._gaugePages.add(gaugePage);
            _nameToGaugepage.put(dsm.getName(), gaugePage);
            this.setCursor(new QCursor(Qt.CursorShape.WaitCursor));
            gaugePage.createDataClients();
            this.setCursor(new QCursor(Qt.CursorShape.ArrowCursor));
        }
        if (this._gaugePages == null || this._gaugePages.isEmpty()) {
            return;
        }
        GaugePage gaugePage2 = this._gaugePages.get(0);
        if (this._gaugePages.size() == 1) {
            this._stacked.addWidget(gaugePage2);
        } else {
            for (int i = 0; i < this._gaugePages.size(); ++i) {
                gaugePage2 = this._gaugePages.get(i);
                this.addTab(gaugePage2, gaugePage2.getName());
            }
        }
        this.setCurrentWidget(this._gaugePages.get(0));
        this._tm = new QTimer();
        this._tm.timeout.connect(this, "timeout()");
        this._tm.start(1000);
        if (this._parent.getUserConfig() != null) {
            this._ucftm = new QTimer();
            this._ucftm.timeout.connect(this, "ucfTimeout()");
            this._ucftm.start(100);
        }
    }

    public GaugePage getCurrentGaugePage() {
        if (this._gaugePages.size() <= 0) {
            return null;
        }
        if (this._gaugePages.size() == 1) {
            return this._gaugePages.get(0);
        }
        return (GaugePage)this.currentWidget();
    }

    public List<Sample> getSamps() {
        return this._samples;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public CockPit getParent() {
        return this._parent;
    }

    public List<GaugePage> getGaugePages() {
        return this._gaugePages;
    }

    public HashMap<String, GaugePage> getNameToGaugePage() {
        return _nameToGaugepage;
    }

    public void closeTab() {
        if (this._gaugePages.size() <= 1) {
            return;
        }
        int n = this.currentIndex();
        GaugePage gaugePage = (GaugePage)this.currentWidget();
        if (gaugePage == null) {
            return;
        }
        if (gaugePage.getPrimary()) {
            this._parent.statusBar().showMessage("Cannot delete a primary page, Cockpit preserved it", 10000);
            return;
        }
        this._gaugePages.remove(gaugePage);
        _nameToGaugepage.remove(gaugePage._name);
        this.removeTab(n);
        gaugePage.destroyWidget(true);
        this.setCurrentIndex(n - 1);
        this.setCurrentWidget(this._gaugePages.get(n - 1));
        this.checkFirstPageTab(false);
    }

    public void toggleFixedGaugeSize(QSizePolicy.Policy policy) {
        if (policy == QSizePolicy.Policy.Preferred && Util.confirmMsgBox("ToVarying will loss all the history data! ", "Toggle Resize") == Util.RetAbort) {
            return;
        }
        this.getCurrentGaugePage().toggleFixedGaugeSize(policy);
    }

    public void gtoggleFixedGaugeSize(QSizePolicy.Policy policy) {
        if (policy == QSizePolicy.Policy.Preferred && Util.confirmMsgBox("ToVarying will loss all the history data! ", "Toggle Resize") == Util.RetAbort) {
            return;
        }
        for (int i = 0; i < this._gaugePages.size(); ++i) {
            this._gaugePages.get(i).toggleFixedGaugeSize(policy);
        }
        this._tm.start(15000);
    }

    public void cleanupHistory() {
        if (Util.confirmMsgBox("Processing \"cleanupHistory\" will loss all the history data! ", "Clean History") == Util.RetAbort) {
            return;
        }
        this.getCurrentGaugePage().cleanupHistory();
    }

    public void gcleanupHistory() {
        if (Util.confirmMsgBox("Processing \"cleanupHistory\" will loss all the history data! ", "Clean History") == Util.RetAbort) {
            return;
        }
        for (int i = 0; i < this._gaugePages.size(); ++i) {
            this._gaugePages.get(i).cleanupHistory();
        }
    }

    public void gautoScalePlots() {
        this.getCurrentGaugePage().gautoScalePlots(true);
    }

    public void ggautoScalePlots() {
        GaugePage gaugePage = (GaugePage)this.currentWidget();
        for (int i = 0; i < this._gaugePages.size(); ++i) {
            this._gaugePages.get(i).gautoScalePlots(true);
        }
        this.setCurrentWidget(gaugePage);
    }

    public void colorCurrent() {
        QColor qColor = QColorDialog.getColor();
        if (qColor.value() == 0) {
            return;
        }
        this.getCurrentGaugePage().colorCurrent(qColor);
    }

    public void gcolorCurrent() {
        QColor qColor = QColorDialog.getColor();
        if (qColor.value() == 0) {
            return;
        }
        for (int i = 0; i < this._gaugePages.size(); ++i) {
            this._gaugePages.get(i).colorCurrent(qColor);
        }
    }

    public void colorHistory() {
        if (Util.confirmMsgBox("Processing \"colorHistory\" will loss all the history data! ", "Color History") == Util.RetAbort) {
            return;
        }
        QColor qColor = QColorDialog.getColor();
        if (qColor.value() == 0) {
            return;
        }
        this.getCurrentGaugePage().colorHistory(qColor);
    }

    public void gcolorHistory() {
        if (Util.confirmMsgBox("Processing \"colorHistory\" will loss all the history data! ", "Color History") == Util.RetAbort) {
            return;
        }
        QColor qColor = QColorDialog.getColor();
        if (qColor.value() == 0) {
            return;
        }
        for (int i = 0; i < this._gaugePages.size(); ++i) {
            this._gaugePages.get(i).colorHistory(qColor);
        }
    }

    public void colorBackGround() {
        if (Util.confirmMsgBox("Processing \"colorBackGround\" will loss all the history data! ", "Color Background") == Util.RetAbort) {
            return;
        }
        QColor qColor = QColorDialog.getColor();
        if (qColor.value() == 0) {
            return;
        }
        this.getCurrentGaugePage().colorBackGround(qColor);
    }

    public void gcolorBackGround() {
        if (Util.confirmMsgBox("Processing \"colorBackGround\" will loss all the history data! ", "Color Background") == Util.RetAbort) {
            return;
        }
        QColor qColor = QColorDialog.getColor();
        if (qColor.value() == 0) {
            return;
        }
        for (int i = 0; i < this._gaugePages.size(); ++i) {
            this._gaugePages.get(i).colorBackGround(qColor);
        }
    }

    public void changePlotTimeMSec() {
        if (Util.confirmMsgBox("Changing-plot-time-range will loss all the history data! ", "Change time span") == Util.RetAbort) {
            return;
        }
        int n = this.getCurrentGaugePage().getGaugeTimeMSec();
        NewTimeMSec newTimeMSec = new NewTimeMSec(null, n);
        int n2 = newTimeMSec.getNewTimeMSec();
        if (n2 <= 0 || n == n2) {
            return;
        }
        for (int i = 0; i < this._gaugePages.size(); ++i) {
            this._gaugePages.get(i).setGaugeTimeMSec(n2);
        }
    }

    public void changeSinglePlotTimeMSec() {
        if (Util.confirmMsgBox("Changing-plot-time-range will loss all the history data! ", "Change time span") == Util.RetAbort) {
            return;
        }
        int n = this.getCurrentGaugePage().getGaugeTimeMSec();
        NewTimeMSec newTimeMSec = new NewTimeMSec(this, n);
        int n2 = newTimeMSec.getNewTimeMSec();
        if (n2 <= 0 || n == n2) {
            return;
        }
        this.getCurrentGaugePage().setGaugeTimeMSec(n2);
    }

    public void setNodataTimeout() {
        int n = this.getCurrentGaugePage().getGaugeNoDataTmout();
        NoDataTimeout noDataTimeout = new NoDataTimeout(this, n);
        int n2 = noDataTimeout.getNewTimeSec();
        if (n2 <= 0 || n == n2) {
            return;
        }
        for (int i = 0; i < this._gaugePages.size(); ++i) {
            this._gaugePages.get(i).setGaugeNoDataTimeout(n2);
        }
    }

    public void setSingleNodataTimeout() {
        int n = this.getCurrentGaugePage().getGaugeNoDataTmout();
        NoDataTimeout noDataTimeout = new NoDataTimeout(null, n);
        int n2 = noDataTimeout.getNewTimeSec();
        if (n2 <= 0 || n == n2) {
            return;
        }
        this.getCurrentGaugePage().setGaugeNoDataTimeout(n2);
    }

    public void pageChanged() {
        GaugePage gaugePage;
        int n = this.currentIndex();
        if (n == this._pidx) {
            Util.prtDbg("curidx=previdx == " + this._pidx);
            return;
        }
        if (this._pidx != -1 && this._gaugePages.size() >= this._pidx + 1 && (gaugePage = this._gaugePages.get(this._pidx)).getPolicy() == QSizePolicy.Policy.Preferred) {
            gaugePage.toggleFixedGaugeSize(QSizePolicy.Policy.Fixed);
        }
        if (this.getCurrentGaugePage() != null) {
            this.syncCurrentSizePolicy(this.getCurrentGaugePage().getPolicy());
        }
        this._pidx = n;
    }

    public void syncCurrentSizePolicy(QSizePolicy.Policy policy) {
        boolean bl = false;
        if (policy == QSizePolicy.Policy.Fixed) {
            bl = true;
        }
        this._parent.syncSizePolicy(bl);
    }

    private void checkFirstPageTab(boolean bl) {
        if (this._gaugePages.size() != 1) {
            return;
        }
        GaugePage gaugePage = this._gaugePages.get(0);
        if (bl) {
            this._stacked.removeWidget(gaugePage);
            this.addTab(gaugePage, gaugePage._name);
            return;
        }
        this.removeTab(0);
        this._stacked.addWidget(gaugePage);
    }

    public GaugePage addNewPage(List<Var> list, String string) {
        if (list.isEmpty()) {
            return null;
        }
        if (_nameToGaugepage.get(string) != null) {
            string = string + "+";
        }
        PostGaugePage postGaugePage = new PostGaugePage((QWidget)this, list, string);
        postGaugePage.addPlots();
        this.checkFirstPageTab(true);
        this._gaugePages.add(postGaugePage);
        _nameToGaugepage.put(string, postGaugePage);
        this.addTab(postGaugePage, postGaugePage._name);
        this.setCurrentWidget(postGaugePage);
        this.setCurrentIndex(this._gaugePages.size() - 1);
        this.syncCurrentSizePolicy(postGaugePage.getPolicy());
        this.update();
        return postGaugePage;
    }

    public void addVariablePage() {
        ArrayList<Var> arrayList;
        GaugePage gaugePage = this.getCurrentGaugePage();
        if (gaugePage == null) {
            return;
        }
        if (gaugePage.getPolicy() == QSizePolicy.Policy.Preferred) {
            gaugePage.setAllPolicy(QSizePolicy.Policy.Fixed);
        }
        if ((arrayList = this._uU.getSortedVars(gaugePage._gauges)).isEmpty()) {
            return;
        }
        String string = gaugePage._name + "Var";
        if (_nameToGaugepage.get(string) != null) {
            string = string + "+";
        }
        PostGaugePage postGaugePage = new PostGaugePage((QWidget)this, arrayList, string);
        postGaugePage.addPlots();
        this.checkFirstPageTab(true);
        this._gaugePages.add(postGaugePage);
        _nameToGaugepage.put(string, postGaugePage);
        this.addTab(postGaugePage, postGaugePage._name);
        this.setCurrentWidget(postGaugePage);
        this.setCurrentIndex(this._gaugePages.size() - 1);
        this.syncCurrentSizePolicy(postGaugePage.getPolicy());
        this.update();
    }

    public void sortVariable() {
        GaugePage gaugePage = this.getCurrentGaugePage();
        if (gaugePage == null) {
            return;
        }
        ArrayList<Gauge> arrayList = gaugePage.getPlots();
        if (arrayList.size() <= 1) {
            return;
        }
        if (gaugePage.getPolicy() == QSizePolicy.Policy.Preferred) {
            gaugePage.toggleFixedGaugeSize(QSizePolicy.Policy.Fixed);
        }
        ArrayList<Gauge> arrayList2 = this._uU.getSortedGauges(arrayList);
        gaugePage.resetGaugeOrder(arrayList2);
        this.update();
    }

    public void gsortVariable() {
        for (int i = 0; i < this._gaugePages.size(); ++i) {
            GaugePage gaugePage = this._gaugePages.get(i);
            if (gaugePage == null) continue;
            ArrayList<Gauge> arrayList = gaugePage.getPlots();
            if (arrayList.size() <= 1) {
                return;
            }
            if (gaugePage.getPolicy() == QSizePolicy.Policy.Preferred) {
                gaugePage.toggleFixedGaugeSize(QSizePolicy.Policy.Fixed);
            }
            ArrayList<Gauge> arrayList2 = this._uU.getSortedGauges(arrayList);
            gaugePage.resetGaugeOrder(arrayList2);
            this.update();
        }
    }

    public void sortHeight() {
        ArrayList<Gauge> arrayList;
        GaugePage gaugePage = this.getCurrentGaugePage();
        if (gaugePage == null) {
            return;
        }
        ArrayList<Gauge> arrayList2 = gaugePage.getPlots();
        if (arrayList2.size() <= 1) {
            return;
        }
        if (gaugePage.getPolicy() == QSizePolicy.Policy.Preferred) {
            gaugePage.toggleFixedGaugeSize(QSizePolicy.Policy.Fixed);
        }
        if ((arrayList = this._uU.getSortedGaugesByHeight(arrayList2)) != null || arrayList.size() > 1) {
            gaugePage.resetGaugeOrder(arrayList);
        }
        this.update();
    }

    public void gsortHeight() {
        for (int i = 0; i < this._gaugePages.size(); ++i) {
            ArrayList<Gauge> arrayList;
            GaugePage gaugePage = this._gaugePages.get(i);
            if (gaugePage == null) continue;
            ArrayList<Gauge> arrayList2 = gaugePage.getPlots();
            if (arrayList2.size() <= 1) {
                return;
            }
            if (gaugePage.getPolicy() == QSizePolicy.Policy.Preferred) {
                gaugePage.toggleFixedGaugeSize(QSizePolicy.Policy.Fixed);
            }
            if ((arrayList = this._uU.getSortedGaugesByHeight(arrayList2)) != null || arrayList.size() > 1) {
                gaugePage.resetGaugeOrder(arrayList);
            }
            this.update();
        }
    }

    public void addHeightPage() {
        ArrayList<Var> arrayList;
        GaugePage gaugePage = this.getCurrentGaugePage();
        if (gaugePage == null) {
            return;
        }
        if (gaugePage.getPolicy() == QSizePolicy.Policy.Preferred) {
            gaugePage.setAllPolicy(QSizePolicy.Policy.Fixed);
        }
        if ((arrayList = this._uU.getSortedVarsByHeight(gaugePage._gauges)).isEmpty()) {
            return;
        }
        String string = gaugePage._name + "Ht";
        if (_nameToGaugepage.get(string) != null) {
            string = string + "+";
        }
        PostGaugePage postGaugePage = new PostGaugePage((QWidget)this, arrayList, string);
        postGaugePage.addPlots();
        this.checkFirstPageTab(true);
        this._gaugePages.add(postGaugePage);
        _nameToGaugepage.put(string, postGaugePage);
        this.setCurrentWidget(postGaugePage);
        this.setCurrentIndex(this._gaugePages.size() - 1);
        this.syncCurrentSizePolicy(postGaugePage.getPolicy());
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSampsFromDataDescriptor(Document document) {
        if (this._dsms != null && !this._dsms.isEmpty()) {
            this.checkSamps(document);
            return;
        }
        CentTabWidget centTabWidget = this;
        synchronized (centTabWidget) {
            this._dsms = this.getDsms(document);
            if (this._dsms == null || this._dsms.isEmpty()) {
                return;
            }
            this.setCursor(new QCursor(Qt.CursorShape.WaitCursor));
            ArrayList<Var> arrayList = new ArrayList<Var>();
            for (int i = 0; i < this._dsms.size(); ++i) {
                Dsm dsm = this._dsms.get(i);
                ArrayList<Sample> arrayList2 = dsm.getSamples();
                if (arrayList2 == null || arrayList2.isEmpty()) continue;
                for (int j = 0; j < arrayList2.size(); ++j) {
                    Sample sample = (Sample)arrayList2.get(j);
                    ArrayList<Var> arrayList3 = sample.getVars();
                    if (arrayList3 == null || arrayList3.isEmpty()) continue;
                    arrayList.addAll(arrayList3);
                }
                this._samples.addAll(arrayList2);
            }
            this.setCursor(new QCursor(Qt.CursorShape.ArrowCursor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSamps(Document document) {
        CentTabWidget centTabWidget = this;
        synchronized (centTabWidget) {
            ArrayList<Sample> arrayList = new ArrayList<Sample>();
            List<Dsm> list = this.getDsms(document);
            if (list == null || list.isEmpty()) {
                return;
            }
            this.setCursor(new QCursor(Qt.CursorShape.WaitCursor));
            ArrayList<Var> arrayList2 = new ArrayList<Var>();
            for (int i = 0; i < list.size(); ++i) {
                Dsm dsm = list.get(i);
                ArrayList<Sample> arrayList3 = dsm.getSamples();
                if (arrayList3 == null || arrayList3.isEmpty()) continue;
                for (int j = 0; j < arrayList3.size(); ++j) {
                    Sample sample = (Sample)arrayList3.get(j);
                    ArrayList<Var> arrayList4 = sample.getVars();
                    if (arrayList4 == null || arrayList4.isEmpty()) continue;
                    arrayList2.addAll(arrayList4);
                }
                arrayList.addAll(arrayList3);
            }
            this.setCursor(new QCursor(Qt.CursorShape.ArrowCursor));
        }
    }

    private List<Dsm> getDsms(Document document) {
        DataDescriptor dataDescriptor = new DataDescriptor(document);
        dataDescriptor.walkSites();
        return dataDescriptor.getAllDsms();
    }

    public boolean isAnyPlot() {
        return this._gaugePages != null && this._gaugePages.get(0) != null && this._gaugePages.get((int)0)._gauges.size() >= 1;
    }

    @Override
    public void mouseReleaseEvent(QMouseEvent qMouseEvent) {
        if (qMouseEvent.button() == Qt.MouseButton.RightButton) {
            QMenu qMenu = new QMenu("");
            QMenu qMenu2 = qMenu.addMenu("RenamePage");
            qMenu2.addAction("&RenamePage", this, "renamePage()");
            int n = qMouseEvent.globalX();
            int n2 = qMouseEvent.globalY();
            qMenu2.popup(new QPoint(n, n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserConfig() {
        CentTabWidget centTabWidget = this;
        synchronized (centTabWidget) {
            this._saveconfig.createCockpitConfig(this);
            this._saveconfig.writeUserConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openUserConfig() {
        CentTabWidget centTabWidget = this;
        synchronized (centTabWidget) {
            this._openconfig.readUserConfig(true);
            this.applyUserConfig(this._openconfig.getCockpitConfig());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openUserConfig(String string) {
        this._openconfig.setConfigName(string);
        CentTabWidget centTabWidget = this;
        synchronized (centTabWidget) {
            this._openconfig.readUserConfig(false);
            this.applyUserConfig(this._openconfig.getCockpitConfig());
        }
    }

    public void rescaleGaugesInTab() {
        Gauge gauge = this.getCurrentGaugePage()._gauges.get(0);
        RescaleDialog rescaleDialog = new RescaleDialog(gauge._ymax, gauge._ymin, this.geometry().width() / 3, this.geometry().height() / 3);
        if (!rescaleDialog.getOk()) {
            return;
        }
        if (rescaleDialog.getMax() <= rescaleDialog.getMin()) {
            Util.prtErr("Y-axis-Max is smaller than Y-axis-Min");
            return;
        }
        ArrayList<Gauge> arrayList = this.getCurrentGaugePage()._gauges;
        for (int i = 0; i < arrayList.size(); ++i) {
            ((Gauge)arrayList.get(i)).changeYMaxMin(rescaleDialog.getMax(), rescaleDialog.getMin());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoCycleTabs() {
        CentTabWidget centTabWidget = this;
        synchronized (centTabWidget) {
            QAction qAction = this._parent._gsetup.actions().get(2);
            String string = qAction.text();
            if (string.equals("AutoCycleTabs")) {
                qAction.setText("StopCycleTabs");
                NoDataTimeout noDataTimeout = new NoDataTimeout(null, 10);
                noDataTimeout.setWindowTitle("Enter Prefered Cycle Time");
                this._cycleInt = noDataTimeout.getNewTimeSec();
                if (this._cycleInt <= 0) {
                    return;
                }
                this._cycleTm.start(this._cycleInt * 1000);
                this._parent._cpConn.getStatusBarClient().receive("Auto_cycle_tabs every " + this._cycleInt + " seconds", -1);
            } else {
                qAction.setText("AutoCycleTabs");
                this._cycleTm.stop();
                this._parent._cpConn.getStatusBarClient().receive("Stop_cycle_tabs", 10000);
            }
        }
    }

    private void renamePage() {
        String string = QInputDialog.getText(this, "Get Page Name", "Enter a new name:", QLineEdit.EchoMode.Normal, "");
        if (string != null) {
            this.setTabText(this.currentIndex(), string);
        }
    }

    private void timeout() {
        this._tm.stop();
        GaugePage gaugePage = (GaugePage)this.currentWidget();
        for (int i = 0; i < this._gaugePages.size(); ++i) {
            GaugePage gaugePage2 = this._gaugePages.get(i);
            this.setCurrentWidget(gaugePage2);
        }
        this.setCurrentWidget(gaugePage);
    }

    private void ucfTimeout() {
        this._ucftm.stop();
        if (this._parent.getUserConfig() != null) {
            this.openUserConfig(this._parent.getUserConfig());
        }
        GaugePage gaugePage = (GaugePage)this.currentWidget();
        for (int i = 0; i < this._gaugePages.size(); ++i) {
            GaugePage gaugePage2 = this._gaugePages.get(i);
            this.setCurrentWidget(gaugePage2);
        }
        this.setCurrentWidget(gaugePage);
    }

    private void cycleTimeout() {
        if (this._cycleInt <= 0) {
            this._cycleTm.stop();
        } else if (this.count() > 0) {
            this.setCurrentIndex((this.currentIndex() + 1) % this.count());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyUserConfig(CockpitConfig cockpitConfig) {
        if (cockpitConfig == null) {
            return;
        }
        CentTabWidget centTabWidget = this;
        synchronized (centTabWidget) {
            this.setWindowTitle(cockpitConfig.getName());
            List<TabPageConfig> list = cockpitConfig.getTabPageConfig();
            for (int i = 0; i < list.size(); ++i) {
                List<Object> list2;
                TabPageConfig tabPageConfig = list.get(i);
                GaugePage gaugePage = _nameToGaugepage.get(tabPageConfig.getName());
                if (gaugePage == null && (list2 = this.abstractVars(tabPageConfig)) != null && list2.size() > 0) {
                    gaugePage = this.addNewPageFromConfig(tabPageConfig, list2, tabPageConfig.getName());
                }
                if (gaugePage == null) {
                    return;
                }
                gaugePage.setWindowTitle(tabPageConfig.getName());
                gaugePage.resize(tabPageConfig.getSize()[0], tabPageConfig.getSize()[1]);
                gaugePage.setPrimary(tabPageConfig.getPrm());
                list2 = tabPageConfig.getUIVars();
                for (int j = 0; j < list2.size(); ++j) {
                    PlotConfig plotConfig = (PlotConfig)list2.get(j);
                    Gauge gauge = gaugePage.getNameToGauge().get(plotConfig.getName());
                    if (gauge == null) continue;
                    if (!gauge._label.equals(plotConfig.getName()) || gauge.getYMax() != plotConfig.getMax() || gauge.getYMin() != plotConfig.getMin()) {
                        gauge._label = plotConfig.getName();
                        gauge.changeYMaxMin(plotConfig.getMax(), plotConfig.getMin());
                    }
                    if (!gauge.getCColor().equals(new QColor(plotConfig.getCColor()))) {
                        gauge._noDataPaint = false;
                        gauge.setCColor(new QColor(plotConfig.getCColor()));
                    }
                    if (!gauge.getHColor().equals(new QColor(plotConfig.getHColor()))) {
                        gauge._noDataPaint = false;
                        gauge.setHColor(new QColor(plotConfig.getHColor()));
                    }
                    if (!gauge.getBGColor().equals(new QColor(plotConfig.getBGColor()))) {
                        gauge._noDataPaint = false;
                        gauge.setBGColor(new QColor(plotConfig.getBGColor()));
                    }
                    if (plotConfig.getNoDataTm() != gauge.getNoDataTmout()) {
                        gauge.setNoDataTmout(plotConfig.getNoDataTm());
                    }
                    if (plotConfig.getplotTmRange() == gauge.getGaugeTimeMSec()) continue;
                    gauge.setNewTimeMSec(plotConfig.getplotTmRange());
                }
            }
        }
    }

    private GaugePage addNewPageFromConfig(TabPageConfig tabPageConfig, List<Var> list, String string) {
        if (list == null) {
            Util.prtErr("addNewPageFromConfig vars is null");
            return null;
        }
        ArrayList<Var> arrayList = new ArrayList<Var>();
        block0: for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i).getName();
            for (Var var : _varToGdc.keySet()) {
                if (!var.getName().equals(string2)) continue;
                arrayList.add(var);
                continue block0;
            }
        }
        if (arrayList.size() < 1) {
            Util.prtErr("addNewPageFromConfig Lvar-gauge is null");
            return null;
        }
        GaugePage gaugePage = this.addNewPage(arrayList, string);
        if (gaugePage == null) {
            Util.prtErr("addNewPage is null");
            return null;
        }
        return gaugePage;
    }

    private List<Var> abstractVars(TabPageConfig tabPageConfig) {
        List<PlotConfig> list = tabPageConfig.getUIVars();
        if (list == null || list.size() <= 0) {
            return null;
        }
        ArrayList<Var> arrayList = new ArrayList<Var>(0);
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i).getName();
            arrayList.add(list.get(i).getVar());
        }
        return arrayList;
    }

    static class PageGeometry {
        public static int x = 350;
        public static int y = 250;
        public static int w = 1000;
        public static int h = 700;

        PageGeometry() {
        }
    }
}

