/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.nidas.apps.cockpit.model.config;

import com.trolltech.qt.core.QDir;
import com.trolltech.qt.gui.QFileDialog;
import edu.ucar.nidas.apps.cockpit.model.config.CockpitConfig;
import edu.ucar.nidas.apps.cockpit.model.config.PlotConfig;
import edu.ucar.nidas.apps.cockpit.model.config.TabPageConfig;
import edu.ucar.nidas.apps.cockpit.ui.CentTabWidget;
import edu.ucar.nidas.model.BasicDom;
import edu.ucar.nidas.util.Util;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class UserConfig
extends BasicDom {
    private CentTabWidget _parent;
    public static String _configName = "cockpitUserConfig.conf";
    private CockpitConfig _cconf;

    public void createCockpitConfig(CentTabWidget centTabWidget) {
        this._parent = centTabWidget;
        if (this._parent == null) {
            Util.prtErr("Cannot createCockpitconfig: parent is null");
            return;
        }
        this.getSaveFileName();
        if (_configName == null || _configName.length() <= 0) {
            return;
        }
        this._cconf = new CockpitConfig(this._parent);
    }

    public String writeUserConfig() {
        if (this._cconf == null) {
            return null;
        }
        if (_configName == null || _configName.length() <= 0) {
            return null;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            this._cconf.writeCockpitConfig(document);
            super.saveXmldoc(document, _configName);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        return _configName;
    }

    public void readUserConfig(boolean bl) {
        this._cconf = null;
        if (bl) {
            this.getOpenFileName();
        }
        if (_configName == null || _configName.length() <= 0) {
            return;
        }
        Document document = this.parseXmlFile(_configName, false);
        if (document == null) {
            return;
        }
        Node node = document.getFirstChild();
        if (node == null) {
            return;
        }
        this._cconf = new CockpitConfig();
        this._cconf.walkCockpitConfig(node);
    }

    public CockpitConfig getCockpitConfig() {
        return this._cconf;
    }

    public void printContent(String string) {
        if (this._cconf == null) {
            return;
        }
        System.out.println(string + this._cconf._name + " =");
        List<TabPageConfig> list = this._cconf.getTabPageConfig();
        for (int i = 0; i < list.size(); ++i) {
            TabPageConfig tabPageConfig = list.get(i);
            System.out.println(string + "tpage=" + tabPageConfig.getName());
            List<PlotConfig> list2 = tabPageConfig.getUIVars();
            for (int j = 0; j < list2.size(); ++j) {
                PlotConfig plotConfig = list2.get(j);
                if (j != 0) continue;
                System.out.println(string + "varui j=" + j + " " + plotConfig.getName() + " " + plotConfig.getMax() + " " + plotConfig.getMin() + " " + plotConfig.getNoDataTm() + " " + plotConfig.getplotTmRange());
                System.out.println("colors= " + plotConfig.getCColor() + " " + plotConfig.getHColor() + " " + plotConfig.getBGColor());
            }
        }
    }

    public void setConfigName(String string) {
        _configName = string;
    }

    private void getOpenFileName() {
        _configName = QFileDialog.getOpenFileName(this._parent, "Open File", QDir.currentPath() + "/" + _configName);
        if (_configName == null || _configName.length() <= 0) {
            // empty if block
        }
    }

    private void getSaveFileName() {
        _configName = QFileDialog.getSaveFileName(this._parent, "Save File", QDir.currentPath() + "/" + _configName);
        if (_configName == null || _configName.length() <= 0) {
            this._parent.getParent().statusBar().showMessage("Save user configure file is NOT selected.", 10000);
        }
    }
}

