/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.nidas.apps.cockpit.model;

import edu.ucar.nidas.apps.cockpit.model.DataClient;
import edu.ucar.nidas.core.FloatSample;
import java.util.ArrayList;

public class MinMaxer
implements DataClient {
    private long _endTime = Long.MIN_VALUE;
    private int _interval;
    private float[] _data = null;
    private ArrayList<DataClient> _clients = new ArrayList();

    public MinMaxer(int n) {
        this._interval = n;
        this._data = new float[2];
        this._data[0] = Float.MAX_VALUE;
        this._data[1] = -3.4028235E38f;
    }

    public void receive(FloatSample floatSample, int n) {
        float f;
        long l = floatSample.getTimeTag();
        if (l >= this._endTime) {
            if (this._endTime > Long.MIN_VALUE && this._data[0] != Float.MAX_VALUE) {
                FloatSample floatSample2 = new FloatSample(this._endTime - (long)(this._interval / 2), floatSample.getId(), this._data);
                this.distribute(floatSample2);
            }
            this._endTime = l + (long)this._interval - l % (long)this._interval;
            this._data[0] = Float.MAX_VALUE;
            this._data[1] = -3.4028235E38f;
        }
        if (Float.isNaN(f = floatSample.getData(n))) {
            return;
        }
        if (f < this._data[0]) {
            this._data[0] = f;
        }
        if (f > this._data[1]) {
            this._data[1] = f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClient(DataClient dataClient) {
        if (dataClient == null) {
            return;
        }
        ArrayList<DataClient> arrayList = this._clients;
        synchronized (arrayList) {
            this.removeClient(dataClient);
            this._clients.add(dataClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClient(DataClient dataClient) {
        if (dataClient == null) {
            return;
        }
        ArrayList<DataClient> arrayList = this._clients;
        synchronized (arrayList) {
            this._clients.remove(dataClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void distribute(FloatSample floatSample) {
        ArrayList<DataClient> arrayList = this._clients;
        synchronized (arrayList) {
            ArrayList<DataClient> arrayList2 = this._clients;
            for (int i = 0; i < arrayList2.size(); ++i) {
                DataClient dataClient = arrayList2.get(i);
                dataClient.receive(floatSample, 0);
            }
        }
    }
}

