/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.nidas.apps.cockpit.model;

import edu.ucar.nidas.apps.cockpit.model.XmlDom;
import edu.ucar.nidas.model.Dsm;
import edu.ucar.nidas.model.Site;
import edu.ucar.nidas.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataDescriptor
extends XmlDom {
    public static String cockpitXml = "cockpit.xml";
    private ArrayList<Site> _sites = new ArrayList(0);

    public DataDescriptor(InputStream inputStream) {
        this._doc = this.parseXmlFile(inputStream, false);
        try {
            this.saveXmldoc(this._doc, "cockpit.xml");
        }
        catch (Exception exception) {
            Util.prtException(exception, "Cannot save cockpit xml file");
        }
    }

    public DataDescriptor(Document document) {
        this._doc = document;
        try {
            this.saveXmldoc(this._doc, "cockpit.xml");
        }
        catch (Exception exception) {
            Util.prtException(exception, "Cannot save cockpit xml file");
        }
    }

    public ArrayList<Site> getSites() {
        return this._sites;
    }

    public ArrayList<Dsm> getAllDsms() {
        ArrayList<Dsm> arrayList = new ArrayList<Dsm>();
        for (int i = 0; i < this._sites.size(); ++i) {
            Site site = this._sites.get(i);
            ArrayList<Dsm> arrayList2 = site.getDsms();
            if (arrayList2 == null || arrayList2.size() <= 0) continue;
            arrayList.addAll(site.getDsms());
        }
        return arrayList;
    }

    public void walkSites() {
        if (this._doc == null) {
            Util.prtDbg("Xml document is null");
            return;
        }
        NodeList nodeList = this._doc.getElementsByTagName("site");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node == null) continue;
            Site site = new Site(node);
            this._sites.add(site);
        }
        this.printAll();
    }

    public void printAll() {
        Util.prtDbg("Print out all data descriptors:");
        for (int i = 0; i < this._sites.size(); ++i) {
            Site site = this._sites.get(i);
            site.printAll();
        }
    }

    public String saveStreamXml(InputStream inputStream) throws IOException {
        Document document = this.parseXmlFile(inputStream, false);
        if (document == null) {
            return null;
        }
        this.saveXmldoc(document, cockpitXml);
        Util.prtDbg(" Plot configure xml is saved...");
        return cockpitXml;
    }
}

