/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.nidas.apps.cockpit.ui;

import com.trolltech.qt.core.QSize;
import com.trolltech.qt.core.QTimer;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QCursor;
import com.trolltech.qt.gui.QFocusEvent;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QInputDialog;
import com.trolltech.qt.gui.QLineEdit;
import com.trolltech.qt.gui.QMenu;
import com.trolltech.qt.gui.QMouseEvent;
import com.trolltech.qt.gui.QResizeEvent;
import com.trolltech.qt.gui.QScrollArea;
import com.trolltech.qt.gui.QSizePolicy;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import edu.ucar.nidas.apps.cockpit.core.CpConnection;
import edu.ucar.nidas.apps.cockpit.model.MinMaxer;
import edu.ucar.nidas.apps.cockpit.ui.CentTabWidget;
import edu.ucar.nidas.apps.cockpit.ui.CockPit;
import edu.ucar.nidas.apps.cockpit.ui.Gauge;
import edu.ucar.nidas.apps.cockpit.ui.GaugeDataClient;
import edu.ucar.nidas.model.Sample;
import edu.ucar.nidas.model.Var;
import edu.ucar.nidas.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaugePage
extends QWidget {
    private QSizePolicy _sizePolicy;
    QGridLayout _gaugelayout;
    QScrollArea _scrollArea;
    ArrayList<Gauge> _gauges = new ArrayList();
    ArrayList<Gauge> _gaugesWait = new ArrayList();
    int _gw = 120;
    int _gh = 80;
    int _rectWidth;
    int rectHeight;
    QColor _currentColor = CockPit.gdefCColor;
    QColor _historyColor = CockPit.gdefHColor;
    QColor _bgColor = CockPit.gdefBColor;
    int _reductionPeriod = 1000;
    int _gaugeWidthMsec = 120000;
    int _gaugeNoDataTmout = 600;
    List<Sample> _samples = new ArrayList<Sample>();
    HashMap<String, Gauge> _nameToGauge = new HashMap(0);
    String _name;
    boolean _primary = true;
    CentTabWidget _parent = null;
    QTimer _tm = new QTimer();

    public GaugePage(CentTabWidget centTabWidget, List<Sample> list, String string) {
        if (centTabWidget == null || list == null || list.isEmpty() || string == null || string.length() <= 0) {
            Util.prtErr("GaugePage doesn't get enough infor to create an instance. \nCheck new GaugePage details");
        }
        super.setParent(centTabWidget);
        this._parent = centTabWidget;
        this._name = string;
        this._samples = list;
        this.createUIs();
        this._tm.timeout.connect(this, "VaryingTimeout()");
        this._tm.start(60000);
    }

    public GaugePage() {
    }

    public void setPrimary(boolean bl) {
        this._primary = bl;
    }

    public boolean getPrimary() {
        return this._primary;
    }

    public void destroyWidget(boolean bl) {
        super.destroy(bl);
    }

    public QSizePolicy.Policy getPolicy() {
        return this._sizePolicy.verticalPolicy();
    }

    public HashMap<String, Gauge> getNameToGauge() {
        return this._nameToGauge;
    }

    public void setGaugeTimeMSec(int n) {
        if (n != this._gaugeWidthMsec) {
            this._gaugeWidthMsec = n;
            for (int i = 0; i < this._gauges.size(); ++i) {
                this._gauges.get(i).setNewTimeMSec(n);
            }
        }
    }

    public int getGaugeTimeMSec() {
        return this._gaugeWidthMsec;
    }

    public int getReductionPeriod() {
        return this._reductionPeriod;
    }

    public void setGaugeNoDataTimeout(int n) {
        if (n != this._gaugeNoDataTmout) {
            this._gaugeNoDataTmout = n;
            for (int i = 0; i < this._gauges.size(); ++i) {
                this._gauges.get(i).setNoDataTmout(n);
            }
        }
    }

    public int getGaugeNoDataTmout() {
        return this._gaugeNoDataTmout;
    }

    public ArrayList<Gauge> getPlots() {
        return this._gauges;
    }

    public String getName() {
        return this._name;
    }

    public QColor getCColor() {
        return this._currentColor;
    }

    public QColor getHColor() {
        return this._historyColor;
    }

    public QColor getBGColor() {
        return this._bgColor;
    }

    public void setBGColor(QColor qColor) {
        this._bgColor = qColor;
    }

    protected void createUIs() {
        this.resize(new QSize(900, 600).expandedTo(this.minimumSizeHint()));
        this.getSizePol(QSizePolicy.Policy.Preferred);
        this.setSizePolicy(this._sizePolicy);
        this._gaugelayout = new QGridLayout();
        QWidget qWidget = new QWidget();
        qWidget.resize(new QSize(800, 600));
        qWidget.setLayout(this._gaugelayout);
        this._scrollArea = new QScrollArea(this);
        this._scrollArea.resize(800, 600);
        this._scrollArea.setWidget(qWidget);
        this._scrollArea.setWidgetResizable(true);
        this._scrollArea.adjustSize();
        this._scrollArea.setHorizontalScrollBarPolicy(Qt.ScrollBarPolicy.ScrollBarAlwaysOff);
        QVBoxLayout qVBoxLayout = new QVBoxLayout(this);
        qVBoxLayout.addWidget(this._scrollArea);
        this.setLayout(qVBoxLayout);
    }

    public void setSamples(List<Sample> list) {
        this._samples = list;
    }

    public List<Sample> getSamples() {
        return this._samples;
    }

    public void addSample(Sample sample) {
        this._samples.remove(sample);
        this._samples.add(sample);
    }

    public void removeSample(Sample sample) {
        this._samples.remove(sample);
    }

    public void removeSamples(List<Sample> list) {
        for (int i = 0; i < list.size(); ++i) {
            this._samples.remove(list.get(i));
        }
    }

    public List<Var> getVars() {
        if (this._gauges == null || this._gauges.size() == 0) {
            return null;
        }
        int n = this._gauges.size();
        ArrayList<Var> arrayList = new ArrayList<Var>();
        for (int i = 0; i < n; ++i) {
            Var var = this._gauges.get(i).getVar();
            if (arrayList.contains(var)) continue;
            arrayList.add(var);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleFixedGaugeSize(QSizePolicy.Policy policy) {
        ArrayList<Gauge> arrayList = this._gauges;
        synchronized (arrayList) {
            if (this._gauges.size() <= 0) {
                return;
            }
            this.getSizePol(policy);
            this.setSizePolicy(this._sizePolicy);
            this._gw = this._gauges.get(0).width();
            this._gh = this._gauges.get(0).height();
            if (policy == QSizePolicy.Policy.Preferred) {
                this._gh = 80;
                this._gw = 120;
            }
            for (int i = 0; i < this._gauges.size(); ++i) {
                this._gauges.get(i).setSizePolicy(this._sizePolicy);
                this._gauges.get(i).setMinimumSize(this._gw, this._gh);
            }
            if (policy == QSizePolicy.Policy.Preferred) {
                this.resize(this.width(), this.height());
            }
        }
    }

    private void getSizePol(QSizePolicy.Policy policy) {
        this._sizePolicy = new QSizePolicy(policy, policy);
        this._sizePolicy.setHorizontalStretch((byte)0);
        this._sizePolicy.setVerticalStretch((byte)0);
        this._sizePolicy.setHeightForWidth(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Gauge createGauge(Var var) {
        GaugePage gaugePage = this;
        synchronized (gaugePage) {
            int n = this._gauges.size();
            int n2 = this.width() / this._gw;
            if (this.width() % this._gw != 0) {
                --n2;
            }
            int n3 = n / n2;
            int n4 = n % n2;
            Gauge gauge = new Gauge(this, this._gw, this._gh, this._gaugeWidthMsec, var);
            if (this._sizePolicy != null) {
                gauge.setSizePolicy(this._sizePolicy);
            }
            this._gauges.add(gauge);
            String string = var.getName();
            this._nameToGauge.put(string, gauge);
            this._gaugelayout.addWidget(gauge, n3, n4);
            return gauge;
        }
    }

    protected void reArrangeGauges() {
        int n;
        if (this._gauges == null || this._gauges.size() < 1) {
            return;
        }
        for (n = 0; n < this._gauges.size(); ++n) {
            this._gaugelayout.removeWidget(this._gauges.get(n));
        }
        n = this.getColNum();
        if (n <= 0) {
            return;
        }
        for (int i = 0; i < this._gauges.size(); ++i) {
            int n2 = i / n;
            int n3 = i % n;
            this._gaugelayout.addWidget(this._gauges.get(i), n2, n3);
        }
        this.update();
    }

    @Override
    public void focusInEvent(QFocusEvent qFocusEvent) {
        if (!this.isActiveWindow()) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetGaugeOrder(ArrayList<Gauge> arrayList) {
        if (this._gauges.size() <= 1) {
            return;
        }
        GaugePage gaugePage = this;
        synchronized (gaugePage) {
            int n;
            for (n = 0; n < this._gauges.size(); ++n) {
                this._gaugelayout.removeWidget(this._gauges.get(n));
            }
            this._gauges.clear();
            this._gauges = new ArrayList();
            this._gauges.addAll(arrayList);
            n = this.getColNum();
            if (n <= 0) {
                return;
            }
            for (int i = 0; i < this._gauges.size(); ++i) {
                int n2 = i / n;
                int n3 = i % n;
                Gauge gauge = this._gauges.get(i);
                if (gauge == null) continue;
                this._gaugelayout.addWidget(gauge, n2, n3++);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resizeEvent(QResizeEvent qResizeEvent) {
        if (!this.isActiveWindow()) {
            return;
        }
        if (qResizeEvent.isAccepted()) {
            GaugePage gaugePage = this;
            synchronized (gaugePage) {
                this.reArrangeGauges();
                if (this._sizePolicy.horizontalPolicy() == QSizePolicy.Policy.Preferred && !this._tm.isActive()) {
                    this._tm.start(60000);
                }
            }
        }
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIt(Gauge gauge) {
        GaugePage gaugePage = this;
        synchronized (gaugePage) {
            int n;
            for (n = 0; n < this._gauges.size(); ++n) {
                this._gaugelayout.removeWidget(this._gauges.get(n));
            }
            this._gauges.remove(gauge);
            this._gaugesWait.add(gauge);
            gauge.hide();
            this.update();
            if (this.getPolicy() == QSizePolicy.Policy.Preferred) {
                this.setAllPolicy(QSizePolicy.Policy.Fixed);
            }
            if ((n = this.getColNum()) <= 0) {
                return;
            }
            for (int i = 0; i < this._gauges.size(); ++i) {
                int n2 = i / n;
                int n3 = i % n;
                this._gaugelayout.addWidget(this._gauges.get(i), n2, n3++);
            }
            this.update();
        }
    }

    public void setAllPolicy(QSizePolicy.Policy policy) {
        this.toggleFixedGaugeSize(policy);
        this.getSizePol(policy);
        this.setSizePolicy(this._sizePolicy);
        if (this._parent != null) {
            this._parent.syncCurrentSizePolicy(policy);
        }
    }

    int getColNum() {
        int n = (int)((double)(this.width() / this._gw) - 0.5);
        if (n <= 4) {
            int n2 = this._gw + 4;
            if (this.width() - n * n2 > n2) {
                ++n;
            }
        }
        if (this.getPolicy() == QSizePolicy.Policy.Preferred) {
            n = this.calColNum();
        }
        return n;
    }

    int calColNum() {
        if (this._gauges == null || this._gauges.size() < 1) {
            return -1;
        }
        int n = 120;
        int n2 = 80;
        int n3 = this.width() * this.height();
        float f = n3 / this._gauges.size();
        if (f <= (float)(n * n2)) {
            return this.width() / n;
        }
        double d = Math.sqrt(f * 3.0f / 2.0f);
        this._gw = (int)Math.round(d);
        this._gh = (int)Math.round(d * 2.0 / 3.0);
        return (int)((double)this.width() / d);
    }

    public void cleanupHistory() {
        for (int i = 0; i < this._gauges.size(); ++i) {
            this._gauges.get(i).initPixmaps();
            this._gauges.get(i).changeCColor(this._currentColor);
        }
    }

    public void gautoScalePlots(boolean bl) {
        for (int i = 0; i < this._gauges.size(); ++i) {
            this._gauges.get(i).autoScalePlot(bl);
        }
    }

    public void colorCurrent(QColor qColor) {
        this._currentColor = qColor;
        for (int i = 0; i < this._gauges.size(); ++i) {
            this._gauges.get(i).changeCColor(this._currentColor);
        }
    }

    public void colorHistory(QColor qColor) {
        this._historyColor = qColor;
        for (int i = 0; i < this._gauges.size(); ++i) {
            this._gauges.get(i).changeHColor(this._historyColor);
        }
    }

    public void colorBackGround(QColor qColor) {
        this._bgColor = qColor;
        for (int i = 0; i < this._gauges.size(); ++i) {
            this._gauges.get(i).changeBGColor(this._bgColor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDataClients() {
        if (this._samples == null || this._samples.size() < 1) {
            Util.prtErr("Pwidget-createDataClient  _samples ==null");
            return;
        }
        this.setCursor(new QCursor(Qt.CursorShape.WaitCursor));
        List<Sample> list = this._samples;
        synchronized (list) {
            Util.prtDbg("createDataClient-begin");
            for (int i = 0; i < this._samples.size(); ++i) {
                Sample sample = this._samples.get(i);
                ArrayList<Var> arrayList = sample.getVars();
                for (int j = 0; j < arrayList.size(); ++j) {
                    Var var = arrayList.get(j);
                    this.createOneDataClient(sample, var);
                }
            }
        }
        this.setCursor(new QCursor(Qt.CursorShape.ArrowCursor));
    }

    private void createOneDataClient(Sample sample, Var var) {
        if (var.getLength() != 1) {
            return;
        }
        MinMaxer minMaxer = new MinMaxer(this._reductionPeriod);
        Gauge gauge = null;
        if (!var.getDynamic() && var.getDisplay()) {
            gauge = this.createGauge(var);
        }
        GaugeDataClient gaugeDataClient = new GaugeDataClient(this, var, gauge);
        CentTabWidget._varToGdc.put(var, gaugeDataClient);
        minMaxer.addClient(gaugeDataClient);
        if (CpConnection._dataTh == null) {
            Util.prtErr("dataTh==null");
            return;
        }
        CpConnection._dataTh.addClient(sample, var, 0, minMaxer);
    }

    public void removeGaugeFromWidget(Gauge gauge) {
        if (gauge.getVar().getDisplay()) {
            return;
        }
        this._gaugelayout.removeEventFilter(gauge);
    }

    public void addGaugeToWidget(Gauge gauge) {
        gauge.getVar().setDisplay(true);
        this._gaugelayout.addWidget(gauge);
    }

    @Override
    public void mouseReleaseEvent(QMouseEvent qMouseEvent) {
        if (qMouseEvent.button() == Qt.MouseButton.RightButton) {
            QMenu qMenu = new QMenu("");
            QMenu qMenu2 = qMenu.addMenu("RenamePage");
            qMenu2.addAction("&RenamePage", this, "renamePage()");
        }
    }

    private void renamePage() {
        String string = QInputDialog.getText(this, "Get Page Name", "Enter a new name:", QLineEdit.EchoMode.Normal, "");
        if (string != null) {
            this.setWindowTitle(string);
        }
    }

    void VaryingTimeout() {
        this._tm.stop();
        if (this._sizePolicy.horizontalPolicy() == QSizePolicy.Policy.Preferred) {
            this.setAllPolicy(QSizePolicy.Policy.Fixed);
        }
    }
}

