/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.nidas.apps.cockpit.ui;

import com.trolltech.qt.gui.QApplication;
import edu.ucar.nidas.apps.cockpit.model.DataClient;
import edu.ucar.nidas.apps.cockpit.ui.Gauge;
import edu.ucar.nidas.apps.cockpit.ui.GaugePage;
import edu.ucar.nidas.core.FloatSample;
import edu.ucar.nidas.model.Var;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class GaugeDataClient
implements DataClient,
Runnable {
    private Gauge _g = null;
    private Var _var;
    private GaugePage _pw = null;
    List<Gauge> _gs = new ArrayList<Gauge>();
    private LinkedList<SampOffset> _samps = new LinkedList();

    public GaugeDataClient(GaugePage gaugePage, Var var, Gauge gauge) {
        this._pw = gaugePage;
        this._var = var;
        this._g = gauge;
    }

    public void addGauge(Gauge gauge) {
        this._gs.add(gauge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(FloatSample floatSample, int n) {
        GaugeDataClient gaugeDataClient = this;
        synchronized (gaugeDataClient) {
            if (this._samps.size() < 100000) {
                this._samps.add(new SampOffset(floatSample, n));
            }
            if (this._samps.size() == 1) {
                QApplication.invokeLater(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        if (this._g == null) {
            if (this._pw == null || this._var == null) {
                return;
            }
            object = this;
            synchronized (object) {
                this._g = this._pw.createGauge(this._var);
            }
        }
        if (this._g == null) {
            return;
        }
        while (true) {
            GaugeDataClient gaugeDataClient = this;
            synchronized (gaugeDataClient) {
                if (this._samps.size() == 0) {
                    return;
                }
                object = this._samps.remove();
                this._g.receive(((SampOffset)object).getSamp(), ((SampOffset)object).getOffset());
                this.distributeDataToPlots(((SampOffset)object).getSamp(), ((SampOffset)object).getOffset());
            }
        }
    }

    private void distributeDataToPlots(FloatSample floatSample, int n) {
        for (int i = 0; i < this._gs.size(); ++i) {
            Gauge gauge = this._gs.get(i);
            if (gauge == null) continue;
            gauge.receive(floatSample, n);
        }
    }

    public void removeClient(DataClient dataClient) {
    }

    public void addClient(DataClient dataClient) {
    }

    class SampOffset {
        FloatSample _samp;
        int _offset;

        public SampOffset(FloatSample floatSample, int n) {
            this._samp = floatSample;
            this._offset = n;
        }

        public FloatSample getSamp() {
            return this._samp;
        }

        public int getOffset() {
            return this._offset;
        }
    }
}

