/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.nidas.apps.cockpit.model.config;

import edu.ucar.nidas.apps.cockpit.model.config.PlotConfig;
import edu.ucar.nidas.apps.cockpit.ui.Gauge;
import edu.ucar.nidas.apps.cockpit.ui.GaugePage;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabPageConfig {
    List<PlotConfig> _uivars = new ArrayList<PlotConfig>();
    String _name;
    boolean _primary;
    int[] _size = new int[2];

    public TabPageConfig(GaugePage gaugePage) {
        this._name = gaugePage.getName();
        this._size[0] = gaugePage.size().width();
        this._size[1] = gaugePage.size().height();
        this.createPlotConfig(gaugePage.getPlots());
        this._primary = gaugePage.getPrimary();
    }

    public TabPageConfig() {
    }

    public String getName() {
        return this._name;
    }

    public int[] getSize() {
        return this._size;
    }

    public List<PlotConfig> getUIVars() {
        return this._uivars;
    }

    public boolean getPrm() {
        return this._primary;
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setSize(int[] nArray) {
        this._size = nArray;
    }

    public void setUIVars(List<PlotConfig> list) {
        this._uivars = list;
    }

    public void setPrm(boolean bl) {
        this._primary = bl;
    }

    public void writeTabpageConfig(Document document, Element element) {
        Element element2 = document.createElement("TabPageConfig");
        element2.setAttribute("name", this._name);
        element2.setAttribute("prim", String.valueOf(this._primary));
        element2.setAttribute("width", String.valueOf(this._size[0]));
        element2.setAttribute("height", String.valueOf(this._size[1]));
        element.appendChild(element2);
        for (int i = 0; i < this._uivars.size(); ++i) {
            this._uivars.get(i).writePlotConfig(document, element2);
        }
    }

    private void createPlotConfig(List<Gauge> list) {
        this._uivars.clear();
        for (int i = 0; i < list.size(); ++i) {
            Gauge gauge = list.get(i);
            PlotConfig plotConfig = new PlotConfig(gauge.getName(), gauge.getVar(), gauge.getYMin(), gauge.getYMax(), gauge.getNoDataTmout(), gauge.getGaugeTimeMSec(), gauge.getCColor().rgb(), gauge.getHColor().rgb(), gauge.getBGColor().rgb());
            this._uivars.add(plotConfig);
        }
    }

    public void walkTabpageConfig(Node node) {
        if (node == null) {
            return;
        }
        String string = this.getValue(node, "name");
        if (string != null && string.length() > 0) {
            this._name = string;
        }
        if ((string = this.getValue(node, "width")) != null && string.length() > 0) {
            this._size[0] = Integer.valueOf(string);
        }
        if ((string = this.getValue(node, "height")) != null && string.length() > 0) {
            this._size[1] = Integer.valueOf(string);
        }
        if ((string = this.getValue(node, "prim")) != null && string.length() > 0) {
            this._primary = Boolean.valueOf(string);
        }
        NodeList nodeList = node.getChildNodes();
        this._uivars.clear();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            PlotConfig plotConfig = new PlotConfig();
            plotConfig.walkPlotConfig(nodeList.item(i));
            this._uivars.add(plotConfig);
        }
    }

    private String getValue(Node node, String string) {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            return null;
        }
        return node2.getNodeValue();
    }
}

