/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.nidas.apps.cockpit.model.config;

import edu.ucar.nidas.apps.cockpit.model.config.TabPageConfig;
import edu.ucar.nidas.apps.cockpit.ui.CentTabWidget;
import edu.ucar.nidas.apps.cockpit.ui.GaugePage;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CockpitConfig {
    String _name;
    List<TabPageConfig> _tabpages = new ArrayList<TabPageConfig>();

    public CockpitConfig() {
    }

    public CockpitConfig(CentTabWidget centTabWidget) {
        this._name = centTabWidget.getName();
        this.createTabpageConfig(centTabWidget.getGaugePages());
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setTabPageConfig(List<TabPageConfig> list) {
        this._tabpages = list;
    }

    public String getName() {
        return this._name;
    }

    public List<TabPageConfig> getTabPageConfig() {
        return this._tabpages;
    }

    public void writeCockpitConfig(Document document) {
        Element element = document.createElement("CockpitConfig");
        element.setAttribute("name", this._name);
        document.appendChild(element);
        int n = this._tabpages.size();
        for (int i = 0; i < n; ++i) {
            this._tabpages.get(i).writeTabpageConfig(document, element);
        }
    }

    public void walkCockpitConfig(Node node) {
        if (node == null) {
            return;
        }
        String string = node.getAttributes().getNamedItem("name").getNodeValue();
        if (string == null || string.length() < 1) {
            return;
        }
        this._name = string;
        this._tabpages.clear();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            TabPageConfig tabPageConfig = new TabPageConfig();
            tabPageConfig.walkTabpageConfig(nodeList.item(i));
            if (tabPageConfig == null) continue;
            this._tabpages.add(tabPageConfig);
        }
    }

    private void createTabpageConfig(List<GaugePage> list) {
        this._tabpages.clear();
        for (int i = 0; i < list.size(); ++i) {
            GaugePage gaugePage = list.get(i);
            TabPageConfig tabPageConfig = new TabPageConfig(gaugePage);
            if (tabPageConfig == null) continue;
            this._tabpages.add(tabPageConfig);
        }
    }
}

