/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.nidas.apps.cockpit.core;

import com.trolltech.qt.gui.QMainWindow;
import edu.ucar.nidas.apps.cockpit.core.ReconnectionClient;
import edu.ucar.nidas.apps.cockpit.model.DataClient;
import edu.ucar.nidas.apps.cockpit.ui.CentTabWidget;
import edu.ucar.nidas.apps.cockpit.ui.CockPit;
import edu.ucar.nidas.apps.cockpit.ui.ServLookup;
import edu.ucar.nidas.core.UdpDataReaderThread;
import edu.ucar.nidas.core.UdpFeed;
import edu.ucar.nidas.model.Var;
import edu.ucar.nidas.ui.StatusBarClient;
import edu.ucar.nidas.util.Util;
import java.net.DatagramSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;

public class CpConnection {
    CockPit _cp;
    ServLookup _servLookup;
    String _servOpt;
    public static UdpDataReaderThread _dataTh;
    UdpFeed _udpFeed;
    CentTabWidget _centWidget;
    StatusBarClient _sbc;

    public CpConnection(CockPit cockPit) {
        this._cp = cockPit;
        this._centWidget = this._cp.getCentWidget();
        this._servOpt = this._cp.getServOpt();
    }

    public boolean connServ() {
        this._servLookup = new ServLookup(null, this._servOpt);
        if (this._servLookup == null) {
            Util.prtErr(" Cannot create ServLookup Diaglog");
            return false;
        }
        this._udpFeed = this._servLookup.getUdpFeed();
        if (!this.connectSampDataTh(this._udpFeed)) {
            return false;
        }
        this._centWidget.setName(this._servLookup.getProjectName());
        String string = this._servLookup.getProjectName() + " COCKPIT";
        ((QMainWindow)this._centWidget.parent()).setWindowTitle(string);
        this._centWidget.setName(string);
        this._centWidget.createPrimaryGauges();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reconnect() {
        CpConnection cpConnection = this;
        synchronized (cpConnection) {
            UdpFeed udpFeed;
            Util.prtDbg("reconnect()");
            if (this._servLookup == null) {
                Util.prtErr(" ServLookup Diaglog doesn't exist");
                return false;
            }
            int n = 0;
            block5: while (true) {
                try {
                    while (true) {
                        Util.prtDbg("re-connect =" + n++);
                        udpFeed = this._servLookup.reconnectUdpFeeder();
                        if (udpFeed != null) break block5;
                        Thread.sleep(5000L);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
            boolean bl = this.connectSampDataTh(udpFeed);
            return bl;
        }
    }

    private boolean connectSampDataTh(UdpFeed udpFeed) {
        if (udpFeed == null) {
            return false;
        }
        Document document = udpFeed.getXmlDoc();
        if (document == null) {
            Util.prtErr(" xml_doc=null... \n Please check data server and retry");
            return false;
        }
        Util.prtDbg("getSampsFromDataDescriptor ======");
        if (this._centWidget.getSamps() == null || this._centWidget.getSamps().size() <= 0) {
            this._centWidget.setSampsFromDataDescriptor(document);
        }
        if (this._centWidget.getSamps() == null || this._centWidget.getSamps().size() <= 0) {
            Util.prtErr(" Samples=null after connection \n Please check data descripttion.");
            return false;
        }
        Socket socket = udpFeed.geTcptSocket();
        if (socket == null) {
            Util.prtErr(" tcpSocket=null... \n Please check data server and retry");
            return false;
        }
        Util.prtDbg("to create UdpDataReadera thread======");
        DatagramSocket datagramSocket = udpFeed.getUdpSocket();
        if (datagramSocket == null) {
            Util.prtErr(" UdpSocket=null... \n Please check data server and retry");
            return false;
        }
        HashMap<Var, ArrayList<ArrayList<DataClient>>> hashMap = new HashMap<Var, ArrayList<ArrayList<DataClient>>>();
        HashMap<Integer, ArrayList<Var>> hashMap2 = new HashMap<Integer, ArrayList<Var>>();
        if (_dataTh != null) {
            hashMap.putAll(_dataTh.getVarToClients());
            hashMap2.putAll(_dataTh.getIdToVars());
            _dataTh.abort();
        }
        _dataTh = new UdpDataReaderThread();
        this._sbc = new StatusBarClient(this._cp.getStatusBar());
        ReconnectionClient reconnectionClient = new ReconnectionClient(this._cp);
        _dataTh.setIdToVars(hashMap2);
        _dataTh.setVarToClients(hashMap);
        _dataTh.setUdpFeed(udpFeed);
        _dataTh.setStatusBar(this._sbc);
        _dataTh.setRC(reconnectionClient);
        _dataTh.start();
        return true;
    }

    public void exitConnection() {
        if (_dataTh != null) {
            _dataTh.abort();
        }
        if (this._udpFeed != null) {
            this._udpFeed.closeSocket();
        }
    }

    public StatusBarClient getStatusBarClient() {
        return this._sbc;
    }
}

