/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt;

import com.trolltech.qt.internal.NativeLibraryManager;
import com.trolltech.qt.internal.Version;
import java.io.File;

public class Utilities {
    public static final int MAJOR_VERSION = 4;
    public static final int MINOR_VERSION = 5;
    public static final int PATCH_VERSION = 0;
    public static final int BUILD_NUMBER = 1;
    public static final String VERSION_STRING = Version.STRING;
    public static OperatingSystem operatingSystem = Utilities.decideOperatingSystem();
    public static Configuration configuration = Utilities.decideConfiguration();
    @Deprecated
    public static boolean implicitLoading = false;
    public static String libSubPath = Utilities.decideLibSubPath();
    @Deprecated
    public static boolean loadFromCache = Utilities.matchProperty("com.trolltech.qt.load-from-cache", "true");

    public static boolean matchProperty(String name, String ... substrings) {
        String value = System.getProperty(name);
        if (value == null) {
            return false;
        }
        if (substrings == null || substrings.length == 0) {
            return value != null;
        }
        for (String s : substrings) {
            if (!value.contains(s)) continue;
            return true;
        }
        return false;
    }

    public static void loadSystemLibraries() {
    }

    public static void loadQtLibrary(String library) {
        Utilities.loadQtLibrary(library, "4");
    }

    public static void loadQtLibrary(String library, String version) {
        NativeLibraryManager.loadQtLibrary(library, version);
    }

    public static void loadJambiLibrary(String library) {
        NativeLibraryManager.loadLibrary(library);
    }

    public static boolean loadLibrary(String lib) {
        try {
            NativeLibraryManager.loadLibrary(lib);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static File jambiTempDir() {
        return NativeLibraryManager.jambiTempDirBase("");
    }

    private static OperatingSystem decideOperatingSystem() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("windows")) {
            return OperatingSystem.Windows;
        }
        if (osName.startsWith("mac os x")) {
            return OperatingSystem.MacOSX;
        }
        return OperatingSystem.Linux;
    }

    private static Configuration decideConfiguration() {
        if (System.getProperty("com.trolltech.qt.debug") != null) {
            return Configuration.Debug;
        }
        return Configuration.Release;
    }

    private static String decideLibSubPath() {
        return operatingSystem == OperatingSystem.Windows ? "bin" : "lib";
    }

    private static String stripLibraryName(String lib) {
        if (operatingSystem != OperatingSystem.Windows) {
            lib = lib.substring(3);
        }
        int dot = -1;
        switch (operatingSystem) {
            case Windows: {
                dot = lib.indexOf(".dll");
                break;
            }
            case Linux: {
                dot = lib.indexOf(".so");
                break;
            }
            case MacOSX: {
                dot = lib.indexOf(".");
            }
        }
        return lib.substring(0, dot);
    }

    public static String unpackPlugins() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Configuration {
        Release,
        Debug;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperatingSystem {
        Windows,
        MacOSX,
        Linux;

    }
}

