/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.internal;

import com.trolltech.qt.QNativePointer;
import com.trolltech.qt.core.QAbstractFileEngine;
import com.trolltech.qt.core.QDate;
import com.trolltech.qt.core.QDateTime;
import com.trolltech.qt.core.QDir;
import com.trolltech.qt.core.QFile;
import com.trolltech.qt.core.QFileInfo;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.core.QTime;
import com.trolltech.qt.internal.QClassPathEngine;
import com.trolltech.qt.internal.QClassPathEntry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QJarEntryEngine
extends QAbstractFileEngine
implements QClassPathEntry {
    private String m_entryFileName = null;
    private JarEntry m_entry = null;
    private JarFile m_jarFile = null;
    private InputStream m_stream = null;
    private BufferedReader m_reader = null;
    private long m_pos = -1L;
    private int m_openMode;
    private boolean m_valid = false;
    private boolean m_directory = false;
    private String m_name;

    public QJarEntryEngine(JarFile jarFile, String fileName, boolean isDirectory) {
        this.m_jarFile = jarFile;
        this.m_directory = isDirectory;
        this.setFileName(fileName);
    }

    @Override
    public void setFileName(String fileName) {
        this.m_entry = null;
        if (this.m_jarFile == null) {
            return;
        }
        if (fileName.length() == 0) {
            this.m_entryFileName = "";
            this.m_name = "";
            this.m_valid = true;
            this.m_directory = true;
            return;
        }
        this.m_entryFileName = fileName;
        this.m_entry = this.m_jarFile.getJarEntry(this.m_entryFileName);
        if (this.m_entry == null && !this.m_directory) {
            this.m_valid = false;
        } else {
            this.m_name = this.m_entry == null ? fileName : this.m_entry.getName();
            this.m_valid = true;
        }
    }

    @Override
    public String classPathEntryName() {
        return this.m_jarFile.getName();
    }

    public boolean isValid() {
        return this.m_valid;
    }

    @Override
    public boolean copy(String newName) {
        int BUFFER_SIZE = 0x100000;
        QNativePointer buffer = new QNativePointer(QNativePointer.Type.Byte, 0x100000);
        QFile newFile = new QFile(newName);
        if (newFile.exists()) {
            return false;
        }
        if (!this.open(new QIODevice.OpenMode(QIODevice.OpenModeFlag.ReadOnly))) {
            return false;
        }
        if (!newFile.open(new QIODevice.OpenMode(QIODevice.OpenModeFlag.WriteOnly))) {
            this.close();
            return false;
        }
        long sz = this.size();
        long i = 0L;
        int bytes_to_read = 0;
        if (sz > 0L) {
            do {
                bytes_to_read = (int)Math.min(sz - i, 0x100000L);
                bytes_to_read = (int)this.read(buffer, bytes_to_read);
                byte[] bytes = new byte[bytes_to_read];
                for (int j = 0; j < bytes_to_read; ++j) {
                    bytes[j] = buffer.byteAt(j);
                }
                if (bytes_to_read <= 0 || newFile.write(bytes) == bytes_to_read) continue;
                return false;
            } while (i < sz && bytes_to_read > 0);
        }
        newFile.close();
        if (!this.close()) {
            return false;
        }
        return i == sz;
    }

    @Override
    public boolean setPermissions(int perms) {
        return false;
    }

    @Override
    public boolean caseSensitive() {
        return true;
    }

    @Override
    public boolean close() {
        if (this.m_stream != null) {
            try {
                this.m_stream.close();
            }
            catch (IOException e) {
                return false;
            }
            this.m_stream = null;
        }
        return true;
    }

    @Override
    public List<String> entryList(QDir.Filters filters, List<String> filterNames) {
        String mentryName;
        if (!this.m_directory) {
            return new LinkedList<String>();
        }
        LinkedList<String> result = new LinkedList<String>();
        if (!filters.isSet(new QDir.Filter[]{QDir.Filter.NoDotAndDotDot}) && filters.isSet(new QDir.Filter[]{QDir.Filter.Dirs})) {
            result.add(".");
            if (this.m_entryFileName.length() > 0) {
                result.add("..");
            }
        }
        if (!filters.isSet(new QDir.Filter[]{QDir.Filter.Readable, QDir.Filter.Writable, QDir.Filter.Executable})) {
            filters.set(new QDir.Filter[]{QDir.Filter.Readable});
        }
        if (!(mentryName = this.m_name).endsWith("/") && mentryName.length() > 0) {
            mentryName = mentryName + "/";
        }
        Enumeration<JarEntry> entries = this.m_jarFile.entries();
        HashSet<String> used = new HashSet<String>();
        while (entries.hasMoreElements()) {
            boolean isDir;
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (entryName.length() <= mentryName.length() || !mentryName.equals(entryName.substring(0, mentryName.length())) || mentryName.equals(entryName)) continue;
            int pos = entryName.indexOf("/", mentryName.length());
            if (pos > 0) {
                entryName = entryName.substring(0, pos);
                isDir = true;
            } else {
                isDir = entry.isDirectory();
                if (!isDir) {
                    isDir = QClassPathEngine.checkIsDirectory(this.m_jarFile, entry);
                }
            }
            if (!filters.isSet(new QDir.Filter[]{QDir.Filter.Readable}) || !filters.isSet(new QDir.Filter[]{QDir.Filter.Dirs}) && isDir || !filters.isSet(new QDir.Filter[]{QDir.Filter.Files}) && !isDir || filterNames.size() > 0 && (!isDir || !filters.isSet(new QDir.Filter[]{QDir.Filter.AllDirs})) && !QDir.match(filterNames, entryName)) continue;
            if (entryName.endsWith("/") && entryName.length() > 1) {
                entryName = entryName.substring(0, entryName.length() - 1);
            }
            if (used.contains(entryName = entryName.substring(mentryName.length()))) continue;
            used.add(entryName);
            result.add(entryName);
        }
        return result;
    }

    @Override
    public QAbstractFileEngine.FileFlags fileFlags(QAbstractFileEngine.FileFlags type) {
        try {
            int flags = 0;
            QFileInfo info = new QFileInfo(this.m_jarFile.getName());
            if (info.exists()) {
                flags |= info.permissions().value() & (QAbstractFileEngine.FileFlag.ReadOwnerPerm.value() | QAbstractFileEngine.FileFlag.ReadGroupPerm.value() | QAbstractFileEngine.FileFlag.ReadOtherPerm.value() | QAbstractFileEngine.FileFlag.ReadUserPerm.value());
            }
            flags = this.m_directory ? (flags |= QAbstractFileEngine.FileFlag.DirectoryType.value()) : (flags |= QAbstractFileEngine.FileFlag.FileType.value());
            return new QAbstractFileEngine.FileFlags((flags | QAbstractFileEngine.FileFlag.ExistsFlag.value()) & type.value());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String fileName(QAbstractFileEngine.FileName file) {
        String entryFileName = this.m_entryFileName;
        if (file == QAbstractFileEngine.FileName.LinkName) {
            return "";
        }
        if (file == QAbstractFileEngine.FileName.DefaultName || file == QAbstractFileEngine.FileName.AbsoluteName || file == QAbstractFileEngine.FileName.CanonicalName) {
            return "classpath:" + this.m_jarFile.getName() + "#" + entryFileName;
        }
        if (file == QAbstractFileEngine.FileName.BaseName) {
            int pos = this.m_entryFileName.lastIndexOf("/");
            return pos >= 0 ? this.m_entryFileName.substring(pos + 1) : entryFileName;
        }
        if (file == QAbstractFileEngine.FileName.PathName) {
            int pos = this.m_entryFileName.lastIndexOf("/");
            return pos > 0 ? this.m_entryFileName.substring(0, pos) : "";
        }
        if (file == QAbstractFileEngine.FileName.CanonicalPathName || file == QAbstractFileEngine.FileName.AbsolutePathName) {
            return "classpath:" + this.m_jarFile.getName() + "#" + this.fileName(QAbstractFileEngine.FileName.PathName);
        }
        throw new IllegalArgumentException("Unknown file name type: " + file);
    }

    @Override
    public QDateTime fileTime(QAbstractFileEngine.FileTime time) {
        if (this.m_entry == null) {
            QFileInfo info = new QFileInfo(this.m_jarFile.getName());
            if (info.exists()) {
                return info.lastModified();
            }
            return new QDateTime();
        }
        long tm = this.m_entry.getTime();
        if (tm == -1L) {
            return new QDateTime();
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(tm));
        return new QDateTime(new QDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5)), new QTime(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14)));
    }

    @Override
    public boolean link(String newName) {
        return false;
    }

    @Override
    public boolean mkdir(String dirName, boolean createParentDirectories) {
        return false;
    }

    @Override
    public boolean open(QIODevice.OpenMode openMode) {
        if (this.m_entry == null) {
            return false;
        }
        if (!openMode.isSet(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly}) && !openMode.isSet(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.Append})) {
            try {
                this.m_stream = this.m_jarFile.getInputStream(this.m_entry);
            }
            catch (IOException e) {
                return false;
            }
            if (this.m_stream != null) {
                if (openMode.isSet(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.Text})) {
                    this.m_reader = new BufferedReader(new InputStreamReader(this.m_stream));
                }
                this.m_pos = 0L;
                this.m_openMode = openMode.value();
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public long pos() {
        return this.m_pos;
    }

    @Override
    public long read(QNativePointer data, long maxlen) {
        if (this.m_stream == null) {
            return -1L;
        }
        if (maxlen > Integer.MAX_VALUE) {
            maxlen = Integer.MAX_VALUE;
        }
        byte[] b = new byte[(int)maxlen];
        int bytes_read = 0;
        try {
            int read = 0;
            while (this.m_stream.available() > 0 && (long)bytes_read < maxlen && read >= 0) {
                read = this.m_stream.read(b, 0, (int)maxlen - bytes_read);
                if (read <= 0) continue;
                for (int i = 0; i < read; ++i) {
                    data.setByteAt(i + bytes_read, b[i]);
                }
                bytes_read += read;
            }
        }
        catch (IOException e) {
            return -1L;
        }
        this.m_pos += (long)bytes_read;
        return bytes_read;
    }

    @Override
    public long readLine(QNativePointer data, long maxlen) {
        if (this.m_stream == null || this.m_reader == null) {
            return -1L;
        }
        int bytes_read = 0;
        try {
            int read;
            while (this.m_stream.available() > 0 && (long)bytes_read < maxlen && (read = this.m_stream.read()) != -1) {
                data.setByteAt(bytes_read++, (byte)read);
                if (read != 10) continue;
                break;
            }
        }
        catch (IOException e) {
            return -1L;
        }
        this.m_pos += (long)bytes_read;
        return bytes_read;
    }

    @Override
    public boolean remove() {
        return false;
    }

    @Override
    public boolean rename(String newName) {
        return false;
    }

    @Override
    public boolean rmdir(String dirName, boolean recursive) {
        return false;
    }

    @Override
    public boolean seek(long offset) {
        try {
            this.m_stream.close();
            if (!this.open(new QIODevice.OpenMode(this.m_openMode))) {
                return false;
            }
            this.m_pos = 0L;
            while (this.m_pos < offset) {
                int skip = (int)Math.min(offset - this.m_pos, Integer.MAX_VALUE);
                this.m_stream.skip(skip);
                this.m_pos += (long)skip;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public String owner(QAbstractFileEngine.FileOwner owner) {
        return "";
    }

    @Override
    public int ownerId(QAbstractFileEngine.FileOwner owner) {
        return -2;
    }

    @Override
    public boolean isRelativePath() {
        return false;
    }

    @Override
    public boolean isSequential() {
        return false;
    }

    @Override
    public boolean setSize(long sz) {
        return false;
    }

    @Override
    public long size() {
        return this.m_entry == null ? 0L : this.m_entry.getSize();
    }

    @Override
    public long write(QNativePointer data, long len) {
        return -1L;
    }
}

