/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.core;

import java.util.ArrayList;
import java.util.List;

public abstract class QMessageHandler {
    private static List<QMessageHandler> handlers;

    public abstract void debug(String var1);

    public abstract void warning(String var1);

    public abstract void critical(String var1);

    public abstract void fatal(String var1);

    public static void installMessageHandler(QMessageHandler handler) {
        if (handlers == null) {
            handlers = new ArrayList<QMessageHandler>();
            QMessageHandler.installMessageHandlerProxy();
        }
        handlers.add(handler);
    }

    public static void removeMessageHandler(QMessageHandler handler) {
        if (handlers != null) {
            handlers.remove(handler);
            if (handlers.isEmpty()) {
                QMessageHandler.removeMessageHandlerProxy();
                handlers = null;
            }
        }
    }

    private static boolean process(int id, String message) {
        if (handlers == null) {
            return false;
        }
        switch (id) {
            case 0: {
                for (QMessageHandler h : handlers) {
                    h.debug(message);
                }
                break;
            }
            case 1: {
                for (QMessageHandler h : handlers) {
                    h.warning(message);
                }
                break;
            }
            case 2: {
                for (QMessageHandler h : handlers) {
                    h.critical(message);
                }
                break;
            }
            case 3: {
                for (QMessageHandler h : handlers) {
                    h.fatal(message);
                }
                break;
            }
        }
        return true;
    }

    private static native void installMessageHandlerProxy();

    private static native void removeMessageHandlerProxy();

    static {
        try {
            Class.forName("com.trolltech.qt.QtJambi_LibraryInitializer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

