/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.nidas.apps.cockpit.ui;

import com.trolltech.qt.core.QRect;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QCloseEvent;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QCursor;
import com.trolltech.qt.gui.QFont;
import com.trolltech.qt.gui.QImage;
import com.trolltech.qt.gui.QMainWindow;
import com.trolltech.qt.gui.QMenu;
import com.trolltech.qt.gui.QMenuBar;
import com.trolltech.qt.gui.QPalette;
import com.trolltech.qt.gui.QSizePolicy;
import com.trolltech.qt.gui.QStatusBar;
import edu.ucar.nidas.apps.cockpit.core.CpConnection;
import edu.ucar.nidas.apps.cockpit.ui.CentTabWidget;
import edu.ucar.nidas.apps.cockpit.ui.HtLookup;
import edu.ucar.nidas.apps.cockpit.ui.UIUtil;
import edu.ucar.nidas.apps.cockpit.ui.VarLookup;
import edu.ucar.nidas.model.Var;
import edu.ucar.nidas.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CockPit<VarLoopup>
extends QMainWindow {
    static QImage gnodataImg = null;
    public static boolean gfixedSize = false;
    public static QColor gdefCColor = new QColor(255, 255, 0);
    public static QColor gdefHColor = new QColor(170, 170, 255);
    public static QColor gdefBColor = new QColor(0, 85, 127);
    public static QColor gdefBColor2 = new QColor(82, 85, 79);
    public static QColor gdefBColor3 = new QColor(85, 85, 127);
    public static QColor gdefBColor4 = new QColor(65, 94, 84);
    public static final int gwdef = 120;
    public static final int ghdef = 80;
    public static int gtabcount = 0;
    QMenu _file;
    QMenu _tabsetup;
    QMenu _add;
    QMenu _gsetup;
    QMenu _config;
    public QStatusBar _statusbar;
    public static HashMap<String, QColor> _orderToColor = new HashMap();
    String _cfUser = null;
    String _servOpt = null;
    CentTabWidget _centWidget = null;
    CpConnection _cpConn;
    int _reductionPeriod = 1000;
    UIUtil _uU = new UIUtil();

    public static boolean isFixedSize() {
        return gfixedSize;
    }

    public CockPit(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            this.parseArg(stringArray);
        }
        this.connectSlotsByName();
        this.setHidden(true);
        this.setGeometry(PageGeometry.x, PageGeometry.y, PageGeometry.w, PageGeometry.h);
        _orderToColor.put("gdefBColor", gdefBColor);
        _orderToColor.put("gdefBColor2", gdefBColor2);
        _orderToColor.put("gdefBColor3", gdefBColor3);
        _orderToColor.put("gdefBColor4", gdefBColor4);
        this._centWidget = new CentTabWidget(this);
        this.setCentralWidget(this._centWidget);
        this.createUIs();
        this.connection();
    }

    @Override
    public void closeEvent(QCloseEvent qCloseEvent) {
        this.disposed();
    }

    public void setServOpt(String string) {
        this._servOpt = string;
    }

    public String getServOpt() {
        return this._servOpt;
    }

    public CentTabWidget getCentWidget() {
        return this._centWidget;
    }

    public QStatusBar getStatusBar() {
        return this._statusbar;
    }

    private void createUIs() {
        this._statusbar = new QStatusBar(this);
        this.setStatusBar(this._statusbar);
        this._statusbar.setObjectName("");
        this._statusbar.showMessage("Start ...", 10000);
        this.createMenuItems();
        this.show();
    }

    private void createMenuItems() {
        QMenuBar qMenuBar = new QMenuBar(this);
        QPalette qPalette = new QPalette(QColor.lightGray);
        qMenuBar.setPalette(qPalette);
        qMenuBar.setObjectName("menuBar");
        qMenuBar.setGeometry(new QRect(0, 0, 1290, 25));
        this.setMenuBar(qMenuBar);
        this._file = qMenuBar.addMenu(" &File");
        qMenuBar.setFont(new QFont("Ariel", 12));
        this._file.addAction("&ConnectServer", this, "connection()");
        this._file.addAction("&Exit", this, "exitApp()");
        this._tabsetup = qMenuBar.addMenu("&TabSetup");
        this._tabsetup.addAction("ToFixedPlotSize", this, "toggleFixedGaugeSize()");
        this._tabsetup.addAction("&AutoScale_Plots", this._centWidget, "gautoScalePlots()");
        this._tabsetup.addAction("&ManualScale_Plots", this._centWidget, "rescaleGaugesInTab()");
        QMenu qMenu = this._tabsetup.addMenu("Color");
        qMenu.addAction("Co&lor_Current", this._centWidget, "colorCurrent()");
        qMenu.addAction("Color_&History", this._centWidget, "colorHistory()");
        qMenu.addAction("Color_&BackGround", this._centWidget, "colorBackGround()");
        qMenu.addAction("&CleanUp_History", this._centWidget, "cleanupHistory()");
        QMenu qMenu2 = this._tabsetup.addMenu("SortBy");
        qMenu2.addAction("Variable", this._centWidget, "sortVariable()");
        qMenu2.addAction("Height", this._centWidget, "sortHeight()");
        this._tabsetup.addAction("DeletePage", this._centWidget, "closeTab()");
        QMenu qMenu3 = this._tabsetup.addMenu("TimeSetup");
        qMenu3.addAction("&PlotTimeRange", this._centWidget, "changeSinglePlotTimeMSec()");
        qMenu3.addAction("&NodataTimeout", this._centWidget, "setSingleNodataTimeout()");
        this._tabsetup.setEnabled(false);
        this._add = qMenuBar.addMenu("Add");
        this._add.addAction("NewPageByVar", this, "addPageByVar()");
        this._add.addAction("NewPageByHt", this, "addPageByHt()");
        this._add.setEnabled(false);
        this._gsetup = qMenuBar.addMenu("&GlobalSetup");
        this._gsetup.addAction("ToFixedPlotSize", this, "gtoggleFixedGaugeSize()");
        this._gsetup.addAction("&AutoScalePlots", this._centWidget, "ggautoScalePlots()");
        this._gsetup.addAction("AutoCycleTabs", this._centWidget, "autoCycleTabs()");
        QMenu qMenu4 = this._gsetup.addMenu("Color");
        qMenu4.addAction("Co&lor_Current", this._centWidget, "gcolorCurrent()");
        qMenu4.addAction("Color_&History", this._centWidget, "gcolorHistory()");
        qMenu4.addAction("Color_&BackGround", this._centWidget, "gcolorBackGround()");
        qMenu4.addAction("&CleanUp_History", this._centWidget, "gcleanupHistory()");
        QMenu qMenu5 = this._gsetup.addMenu("SortBy");
        qMenu5.addAction("Variable", this._centWidget, "gsortVariable()");
        qMenu5.addAction("Height", this._centWidget, "gsortHeight()");
        QMenu qMenu6 = this._gsetup.addMenu("TimeSetup");
        qMenu6.addAction("&PlotTimeRange", this._centWidget, "changePlotTimeMSec()");
        qMenu6.addAction("&NodataTimeout", this._centWidget, "setNodataTimeout()");
        this._gsetup.setEnabled(false);
        this._config = qMenuBar.addMenu("&Config");
        this._config.addAction("&Save_Config", this, "saveUserConfig()");
        this._config.addAction("&Open_Config", this, "openUserConfig()");
        this._config.setEnabled(false);
    }

    public void exitApp() {
        this.disposed();
    }

    @Override
    public void disposed() {
        this._cpConn.exitConnection();
        System.exit(0);
    }

    public void setUserConfig(String string) {
        this._cfUser = string;
    }

    public String getUserConfig() {
        return this._cfUser;
    }

    private void toggleFixedGaugeSize() {
        gfixedSize = !gfixedSize;
        this.syncSizePolicy(gfixedSize);
        QSizePolicy.Policy policy = QSizePolicy.Policy.Preferred;
        if (gfixedSize) {
            policy = QSizePolicy.Policy.Fixed;
        }
        this._centWidget.toggleFixedGaugeSize(policy);
    }

    private void gtoggleFixedGaugeSize() {
        gfixedSize = !gfixedSize;
        this.syncSizePolicy(gfixedSize);
        QSizePolicy.Policy policy = QSizePolicy.Policy.Preferred;
        if (gfixedSize) {
            policy = QSizePolicy.Policy.Fixed;
        }
        this._centWidget.gtoggleFixedGaugeSize(policy);
    }

    private void addPageByVar() {
        ArrayList<Var> arrayList = new ArrayList<Var>();
        int n = this._centWidget._gaugePages.size();
        for (int i = 0; i < n; ++i) {
            List<Var> list = this._centWidget._gaugePages.get(i).getVars();
            list = this._uU.getSortedVars(list);
            for (int j = 0; j < list.size(); ++j) {
                Var var = list.get(j);
                if (var == null || arrayList.contains(var)) continue;
                arrayList.add(var);
            }
        }
        new VarLookup(null, this, arrayList);
    }

    private void addPageByHt() {
        ArrayList<Var> arrayList = new ArrayList<Var>();
        int n = this._centWidget._gaugePages.size();
        for (int i = 0; i < n; ++i) {
            List<Var> list = this._centWidget._gaugePages.get(i).getVars();
            for (int j = 0; j < list.size(); ++j) {
                Var var = list.get(j);
                if (var == null || arrayList.contains(var)) continue;
                arrayList.add(var);
            }
        }
        new HtLookup(null, this, arrayList);
    }

    private void saveUserConfig() {
        this._centWidget.saveUserConfig();
    }

    private void openUserConfig() {
        this._centWidget.openUserConfig();
    }

    public void syncSizePolicy(boolean bl) {
        gfixedSize = bl;
        if (bl) {
            this._tabsetup.actions().get(0).setText("ToVaryingPlotSize");
            this._gsetup.actions().get(0).setText("ToVaryingPlotSize");
        } else {
            this._tabsetup.actions().get(0).setText("ToFixedPlotSize");
            this._gsetup.actions().get(0).setText("ToFixedPlotSize");
        }
    }

    public boolean connection() {
        this.openImage();
        this.setCursor(new QCursor(Qt.CursorShape.WaitCursor));
        this._cpConn = new CpConnection(this);
        boolean bl = this._cpConn.connServ();
        if (bl) {
            if (!this._centWidget.isAnyPlot()) {
                this._statusbar.showMessage("   No sensor data yet...", 10000);
            }
            this._tabsetup.setEnabled(true);
            this._add.setEnabled(true);
            this._gsetup.setEnabled(true);
            this._config.setEnabled(true);
            this._file.actions().get(0).setEnabled(false);
        }
        this.setCursor(new QCursor(Qt.CursorShape.ArrowCursor));
        return bl;
    }

    public void reconnect() {
        this.setCursor(new QCursor(Qt.CursorShape.WaitCursor));
        this._cpConn.reconnect();
        this.setCursor(new QCursor(Qt.CursorShape.ArrowCursor));
    }

    private void openImage() {
        if (gnodataImg != null) {
            return;
        }
        String string = "classpath:image/nodata.png";
        gnodataImg = new QImage(string);
        gnodataImg.setColor(1, QColor.red.rgb());
    }

    private void parseArg(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String[] stringArray2;
            if (stringArray[i].equals("-s") && i + 1 < stringArray.length) {
                this.setServOpt(stringArray[++i]);
            } else if (stringArray[i].equals("-debug") && i + 1 < stringArray.length && stringArray[++i].equals("true")) {
                Util.setDebug(true);
            } else if (stringArray[i].equals("-c") && i + 1 < stringArray.length) {
                this.setUserConfig(stringArray[++i]);
            }
            if (!stringArray[i].equals("-arg") && (!stringArray[i].equals("-open") || i + 1 >= stringArray.length)) continue;
            if ((stringArray2 = (string = stringArray[++i]).split(" ")).length != 2) {
                Util.prtErr("option is not a pair" + string);
                continue;
            }
            this.parseArg(stringArray2);
        }
    }

    public static void main(String[] stringArray) {
        QApplication.initialize(stringArray);
        CockPit cockPit = new CockPit(stringArray);
        QApplication.exec();
    }

    static class PageGeometry {
        public static int x = 350;
        public static int y = 250;
        public static int w = 1000;
        public static int h = 700;

        PageGeometry() {
        }
    }
}

