/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.internal;

public class OSInfo {
    private static OS os;
    private static String osArchName;

    public static OS os() {
        if (os == null) {
            String osname = System.getProperty("os.name").toLowerCase();
            os = osname.contains("linux") ? OS.Linux : (osname.contains("windows") ? OS.Windows : (osname.contains("mac os x") ? OS.MacOS : (osname.contains("sunos") ? OS.Solaris : OS.Unknown)));
        }
        return os;
    }

    public static String osArchName() {
        if (osArchName == null) {
            switch (OSInfo.os()) {
                case Windows: {
                    osArchName = System.getProperty("os.arch").equalsIgnoreCase("amd64") ? "win64" : "win32";
                    break;
                }
                case Linux: {
                    osArchName = System.getProperty("os.arch").equalsIgnoreCase("amd64") ? "linux64" : "linux32";
                    break;
                }
                case MacOS: {
                    osArchName = "macosx";
                    break;
                }
                case Solaris: {
                    osArchName = "sunos";
                    break;
                }
                case Unknown: {
                    osArchName = "unknown";
                }
            }
        }
        return osArchName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OS {
        Unknown,
        Windows,
        Linux,
        MacOS,
        Solaris;

    }
}

